% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviates.R
\name{get_deviates}
\alias{get_deviates}
\title{Return a set of vectors with chosen shapes}
\usage{
get_deviates(k, shapes = c("linear", "U", "wave"), constrain = FALSE)
}
\arguments{
\item{k}{an integer. The number of possible ranks.}

\item{shapes}{a vector of character strings. The required shapes of the
vectors.}

\item{constrain}{a logical. If \code{TRUE} the returned set of vectors
is constrained to be orthonormal, with each vector having components
summing to 0. This is required to use the vectors in the Jolliffe-Primo
flatness test.}
}
\value{
An \code{rkhist} object with each row representing a vector of
deviation from flatness.
}
\description{
This function returns an \code{rkhist} object containing vectors with chosen
shapes or trends. This is intended to be used to apply the Jolliffe-Primo
flatness tests of rank histograms (see Jolliffe and Primo, 2008).
}
\details{
The convention is that each row of the \code{rkhist} object contains a
vector. It is not required that the set be a basis.

For each shape in \code{shapes} this function calls a function named
'deviate_shape' with one argument \code{k}. Some pre-coded functions already
exist but the user can easily add its own by following this naming
convention. The added function must have only one argument \code{k} and
return an \code{rkhist} object. It is advised that the returned deviate
vector's components should sum to 0 and have a unit module. But this can be
imposed by setting the argument \code{constrain} to \code{TRUE}.

If \code{constrain == TRUE} the vector set is modified to have the right
properties to be used in the Jolliffe-Primo test, through the Grahm-Schmidt
method. It is strongly advised to plot the resulting set with function
\code{flatness::plot}, since this transformation may greatly change the
shape of the original vectors.
}
\examples{
deviates <- get_deviates(k = 36, shapes = c("linear", "U", "V", "ends", "wave"))
plot(deviates)
isJPOK <- is_JP_ready(deviates)
JPdeviates <- make_JP_ready(deviates)
plot(JPdeviates)
JPcheck <- is_JP_ready(JPdeviates)
}
\references{
\itemize{
\item Jolliffe, Ian T., and Cristina Primo. "Evaluating rank histograms using
decompositions of the chi-square test statistic." \emph{Monthly Weather
Review} 136.6 (2008): 2133-2139. doi:https://doi.org/10.1175/2007MWR2219.1
\item Zamo, Michaël, Liliane Bel, and Olivier Mestre. "Sequential aggregation
of probabilistic forecasts—application to wind speed ensemble forecasts."
Journal of the Royal Statistical Society: Series C (Applied Statistics) 70.1
(2021): 202-225. doi:https://doi.org/10.1111/rssc.12455
\item Zamo, Michaël. Statistical Post-processing of Deterministic and
Ensemble Wind Speed Forecasts on a Grid. Diss. Université Paris-Saclay
(ComUE), 2016.}
}
