% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotInformationContent.R
\name{plotInformationContent}
\alias{plotInformationContent}
\title{Plot Information Content}
\usage{
plotInformationContent(feat.object, control)
}
\arguments{
\item{feat.object}{[\code{\link{FeatureObject}}]\cr
A feature object as created by \code{\link{createFeatureObject}}.}

\item{control}{[\code{list}]\cr
A \code{list}, which stores additional control arguments.
For further information, see details.}
}
\value{
[\code{plot}].\cr
  A plot visualizing the Information Content Features.
}
\description{
Creates a plot of the Information Content Features.
}
\details{
Possible \code{control} arguments are:
  \itemize{
    \item{Computation of Information Content Features}: \itemize{
      \item{\code{ic.epsilon}}: Epsilon values as described in section V.A
      of Munoz et al. (2015). The default is
      \code{c(0, 10^(seq(-5, 15, length.out = 1000))}.
      \item{\code{ic.sorting}}: Sorting strategy, which is used to define
      the tour through the landscape. Possible values are \code{"nn"}
      (= default) and \code{"random"}.
      \item{\code{ic.sample.generate}}: Should the initial design be created
      using a LHS? The default is \code{FALSE}, i.e. the initial design from
      the feature object will be used.
      \item{\code{ic.sample.dimensions}}: Dimensions of the initial sample,
      if created using a LHS. The default is \code{feat.object$dimension}.
      \item{\code{ic.sample.size}}: Size of the initial sample, if created
      using a LHS. The default is \code{100 * feat.object$dimension}.
      \item{\code{ic.sample.lower}}: Lower bounds of the initial sample, if
      created with a LHS. The default is \code{100 * feat.object$lower}.
      \item{\code{ic.sample.upper}}: Upper bounds of the initial sample, if
      created with a LHS. The default is \code{100 * feat.object$upper}.
      \item{\code{ic.show_warnings}}: Should warnings be shown, when
      possible duplicates are removed? The default is \code{FALSE}.
      \item{\code{ic.seed}}: Possible seed, which can be used for making
      your experiments reproducable. Per default, a random number will be
      drawn as seed.
      \item{\code{ic.nn.start}}: Which observation should be used as
      starting value, when exploring the landscape with the nearest
      neighbour approach. The default is a randomly chosen integer value.
      \item{\code{ic.nn.neighborhood}}: In order to provide a fast
      computation of the features, we use \code{RANN::nn2} for computing
      the nearest neighbors of an observation. Per default, we consider
      the \code{20L} closest neighbors for finding the nearest
      not-yet-visited observation. If all of those neighbors have been
      visited already, we compute the distances to the remaining points
      separately.
      \item{\code{ic.settling_sensitivity}}: Threshold, which should be
      used for computing the \dQuote{settling sensitivity}. The default
      is \code{0.05} (as used in the corresponding paper).
      \item{\code{ic.info_sensitivity}}: Portion of partial information
      sensitivity. The default is \code{0.5} (as used in the paper).
    }
    \item{Plot Control}: \itemize{
      \item{\code{ic.plot.{xlim, ylim, las, xlab, ylab}}}: Settings of the
      plot in general, cf. \code{\link[graphics]{plot.default}}.
      \item{\code{ic.plot.{xlab_line, ylab_line}}}: Position of \code{xlab}
      and \code{ylab}.
      \item{\code{ic.plot.ic.{lty, pch, cex, pch_col}}}: Type, width and colour
      of the line visualizing the \dQuote{Information Content} \eqn{H(\epsilon)}.
      \item{\code{ic.plot.max_ic.{lty, pch, lwd, cex, line_col, pch_col}}}:
      Type, size and colour of the line and point referring to the
      \dQuote{Maximum Information Content} \eqn{H[max]}.
      \item{\code{ic.plot.settl_sens.{pch, cex, col}}}:
      Type, size and colour of the point referring to the
      \dQuote{Settling Sensitivity} \eqn{\epsilon[s]}.
      \item{\code{ic.plot.partial_ic}}: Should the information of the partial
      information content be plotted as well? The default is \code{TRUE}.
      \item{\code{ic.plot.partial_ic.{lty, pch, lwd, cex, line_col, pch_col}}}:
      Type, size and colour of the line and point referring to the
      \dQuote{Initial Partial Information} \eqn{M[0]} and the
      \dQuote{Partial Information Content} \eqn{M(\epsilon)}.
      \item{\code{ic.plot.half_partial.{pch, cex, pch_col}}}:
      Type, size and colour of the point referring to the
      \dQuote{Relative Partial Information Sensitivity} \eqn{\epsilon[ratio]}.
      \item{\code{ic.plot.half_partial.{lty, line_col, lwd}_{h, v}}}:
      Type, colour and width of the horizontal and vertical lines referring
      to the \dQuote{Relative Partial Information Sensitivity} \eqn{\epsilon[ratio]}.
      \item{\code{ic.plot.half_partial.text_{cex, col}}}:
      Size and colour of the text at the horizontal line of the
      \dQuote{Relative Partial Information Sensitivity} \eqn{\epsilon[ratio]}.
      \item{\code{ic.plot.legend_{descr, points, lines, location}}}:
      Description, points, lines and location of the legend.
    }
  }
}
\examples{
# (1) create a feature object:
X = t(replicate(n = 2000, expr = runif(n = 5, min = -10, max = 10)))
feat.object = createFeatureObject(X = X, fun = function(x) sum(x^2))

# (2) plot its information content features:
plotInformationContent(feat.object)
}
\references{
\itemize{
    \item{Munoz, M. A., Kirley, M., and Halgamuge, S. K. (2015)}:
    \dQuote{Exploratory Landscape Analysis of Continuous Space Optimization
    Problems Using Information Content}, in: IEEE Transactions on
    Evolutionary Computation (19:1), pp. 74-87
    (\url{http://dx.doi.org/10.1109/TEVC.2014.2302006}).
  }
}
