% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{setFixest_na_inf.rm}
\alias{setFixest_na_inf.rm}
\alias{getFixest_na_inf.rm}
\title{Sets/gets whether to remove NA/Inf values from \code{fixest} estimations}
\usage{
setFixest_na_inf.rm(x)

getFixest_na_inf.rm()
}
\arguments{
\item{x}{A Logical.}
}
\description{
Sets/gets the default policy of NA/Inf behavior in \code{fixest} estimations. By default, NA/Inf values are removed (and a note is displayed). If you prefer a no NA policy, just set \code{setFixest_na_inf.rm(FALSE)}.
}
\examples{

\donttest{
base = iris
base[1, 1] = NA
# default: NAs removed
res = feols(Sepal.Length ~ Sepal.Width, base)
# no tolerance: estimation fails
res = feols(Sepal.Length ~ Sepal.Width, base, na_inf.rm = FALSE)
# to set no tolerance as default:
setFixest_na_inf.rm(FALSE)
}

}
\author{
Laurent Berge
}
