\name{fpConditionCheck}
\alias{fpConditionCheck}
\alias{fpConditionCheck1}
\alias{fpConditionCheck2}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Checks preconditions before performing fpANOVA}
\description{
This function checks whether two conditions are met before performing fpANOVA.
}
\usage{
fpConditionCheck(object)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{object}{a list of objects from class fpp.}
}
\value{No return value, called for warnings generated by \code{fpConditionCheck1} and \code{fpConditionCheck2}}

\details{
Finding support for the fixed-point property will be mute if there is no significant
difference between experimental conditions. Whether all conditions differ can be tested 
using \code{fpConditionCheck1}, which performs pairwise t-tests. A warning is provided if
at least one paire of conditions does not significantly differ (default settings of
\code{pairwise.t.test} are used).

Finding support for the fixed-point property is difficult if the bandwidth of the density 
estimation is chosen too small. In that case, multiple crossing points of pairs of densities
will preclude a precise estimate of the fixed point. \code{fpConditionCheck2} tests the number
of crossing points for each pair of conditions, and provides a warning if more crossing points
are detected.
}

\references{
Van Maanen, L., De Jong, R., Van Rijn, H (2014). How to assess the existence of competing strategies in cognitive tasks: A primer on the fixed-point property. PLOS One, 9, e106113

Van Maanen, L. Couto, J. & Lebetron, M. (2016). Three boundary conditions for computing the fixed-point property in binary mixture data. PLOS One, 11, e0167377.}
\author{
Leendert van Maanen  (l.vanmaanen@uu.nl)
}


%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{fpAnova}}, \code{\link{pairwise.t.test}}
}

\examples{
N <- 200  # nr of observations per condition
M <- 50  # nr of participants
p <- seq(0.1, 0.9, 0.4)  # mixture proportions
means <- c(0.3, 0.3)  # means of base distributions are equal, yielding a warning if check=TRUE
sigma <- 5  # scale of base distributions

bw <- 0.01 
# kernel bandwidth of the density estimation. Too small values yield a warning if check=TRUE

### generate data
rt <- NULL
for (i in 1:length(p)) {
    rt <- c(rt, ifelse(sample(0:1, N * M, replace = TRUE, prob = c(p[i], 1 - p[i])), 
        rnorm(N * M, means[1], sigma), rnorm(N * M, means[2], sigma)))
}
rt <- rt + rep(rnorm(M, sd = 0.1), times = N)  # normally distributed pp random effect
dat <- data.frame(rt = rt, cond = rep(1:length(p), each = N * M), pp = rep(1:M, 
    each = N))

### compute crossing points
res <- tapply(1:nrow(dat), dat$pp, function(X) {
    fpGet(dat[X, ], 1000, bw = bw)
})  

### test fixed point
fpAnova(res, stat = "both", check=TRUE) # this provides both warnings

}
