% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bachelorette}
\alias{bachelorette}
\title{Bachelorette / Bachelor}
\format{
A data frame with 887 rows representing the Bachelorette and Bachelor contestants and 23 variables:
\describe{
  \item{show}{Bachelor or Bachelorette.}
  \item{season}{Which season?}
  \item{contestant}{An identifier for the contestant in a given season.}
  \item{elimination_1}{Who was eliminated in week 1.}
  \item{elimination_2}{Who was eliminated in week 2.}
  \item{elimination_3}{Who was eliminated in week 3.}
  \item{elimination_4}{Who was eliminated in week 4.}
  \item{elimination_5}{Who was eliminated in week 5.}
  \item{elimination_6}{Who was eliminated in week 6.}
  \item{elimination_7}{Who was eliminated in week 7.}
  \item{elimination_8}{Who was eliminated in week 8.}
  \item{elimination_9}{Who was eliminated in week 9.}
  \item{elimination_10}{Who was eliminated in week 10.}
  \item{dates_1}{Who was on which date in week 1.}
  \item{dates_2}{Who was on which date in week 2.}
  \item{dates_3}{Who was on which date in week 3.}
  \item{dates_4}{Who was on which date in week 4.}
  \item{dates_5}{Who was on which date in week 5.}
  \item{dates_6}{Who was on which date in week 6.}
  \item{dates_7}{Who was on which date in week 7.}
  \item{dates_8}{Who was on which date in week 8.}
  \item{dates_9}{Who was on which date in week 9.}
  \item{dates_10}{Who was on which date in week 10.}
}
}
\source{
\url{https://bachelor-nation.fandom.com/wiki/Bachelor_Nation_Wiki}
and then missing seasons were filled in by ABC and FiveThirtyEight staffers.
}
\usage{
bachelorette
}
\description{
The raw data behind the stories:
"How To Spot A Front-Runner On The 'Bachelor' Or 'Bachelorette'"
\url{https://fivethirtyeight.com/features/the-bachelorette/}, "Rachel's Season Is Fitting Neatly Into 'Bachelorette' History"
\url{https://fivethirtyeight.com/features/rachels-season-is-fitting-neatly-into-bachelorette-history/}, and "Rachel Lindsay's 'Bachelorette' Season, In Three Charts"
\url{https://fivethirtyeight.com/features/rachel-lindsays-bachelorette-season-in-three-charts/}.
}
\details{
Eliminates connote either an elimination (starts with "E") or a rose
(starts with "R"). Eliminations supersede roses. "E" connotes a standard
elimination, typically at a rose ceremony. "EQ" means the contestant quits.
"EF" means the contestant was fired by production. "ED" connotes a date
elimination. "EU" connotes an unscheduled elimination, one that takes place
at a time outside of a date or rose ceremony. "R" means the contestant
received a rose. "R1" means the contestant got a first impression rose.
"D1" means a one-on-one date, "D2" means a 2-on-1, "D3" means a 3-on-1
group date, and so on. Weeks of the show are eliminated by rose
ceremonies, and may not line up exactly with episodes.
}
\keyword{datasets}
