% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_vectorfield.R
\name{predict.vectorfield}
\alias{predict.vectorfield}
\title{Calculate the vector value at a given position}
\usage{
\method{predict}{vectorfield}(object, pos, linear_interp = FALSE, calculate_a = TRUE, ...)
}
\arguments{
\item{object}{A \code{vectorfield} project generated by \code{\link[=fit_2d_vf]{fit_2d_vf()}}.}

\item{pos}{A vector, the position of the vector.}

\item{linear_interp}{Use linear interpolation method to estimate the drift vector (and the diffusion matrix). This can speed up the calculation. If \code{TRUE}, be sure that a linear grid was calculated for the vector field using \verb{<vf> <- add_interp_grid(<vf>)}.}

\item{calculate_a}{Effective when \code{linear_interp == TRUE}. Do you want to calculate the diffusion matrix? Use \code{FALSE} can save some time.}

\item{...}{Not in use.}
}
\value{
A list of \code{v}, the drift part that is used for vector fields, and \code{a} (when \code{calculate_a == TRUE}), the diffusion part at a given position.
}
\description{
Calculate the vector value at a given position
}
\seealso{
\code{\link[=add_interp_grid]{add_interp_grid()}}
}
