% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heart-rate.R
\name{heart_rate_intraday}
\alias{heart_rate_intraday}
\title{Heart Rate Intraday}
\usage{
heart_rate_intraday(date, minutes = TRUE)
}
\arguments{
\item{date}{The start date of records to be returned in "yyyy-mm-dd" or date(time) format}

\item{minutes}{a boolean for whether data should be returned in minutes (TRUE) or seconds (FALSE)}
}
\value{
A tibble of the \code{time} and your \code{heart_rate} at that time.
}
\description{
Returns heart rate data for the specified day
}
\details{
See \url{https://dev.fitbit.com/reference/web-api/heart-rate/#get-heart-rate-time-series} for more details.
}
\examples{
\dontrun{
date <- lubridate::today()

## get minute by minute data
heart_rate_intraday(date, minutes = TRUE)

## get more granular data
##  (not necessarily by second, but more granular than minutes)
heart_rate_intraday(date, minutes = FALSE)
}
}
