% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootCI.R
\name{bootCI}
\alias{bootCI}
\alias{bootCI.default}
\alias{bootCI.psData}
\alias{bootCI.psFit}
\title{Bootstrap confidence intervals or regions}
\usage{
bootCI(x, ...)

\method{bootCI}{default}(
  x,
  level = 0.95,
  B = 2000,
  model = c("zeta", "zi.zeta"),
  silent = FALSE,
  plot = FALSE,
  parallel = TRUE,
  progressBar = FALSE,
  pbopts = list(type = "txt"),
  ...
)

\method{bootCI}{psData}(x, ...)

\method{bootCI}{psFit}(x, ...)
}
\arguments{
\item{x}{a object of class \code{psFit}---see \code{\link{readData}} for more
details.}

\item{...}{other arguments.}

\item{level}{the confidence level required---restricted to [0.75, 1). This
may be a vector, in which case multiple intervals, or confidence regions
will be returned.}

\item{B}{the number of bootstrap samples to take.}

\item{model}{which model to fit to the data, either \code{"zeta"} or
\code{"zi.zeta"}. Maybe abbreviated to \code{"z"} and \code{"zi"}. Default
is \code{"zeta"}.}

\item{silent}{if \code{TRUE}, then no output will be displayed whilst the
bootstrapping is being undertaken. \code{plot} if \code{TRUE} then the
contours for the confidence region will be plotted. This only works if
\code{model = "zi.zeta"}. It is ignored otherwise. \code{parallel} if
\code{TRUE} then the bootstrapping is performed in parallel.}

\item{plot}{if \code{TRUE} and \code{model == "zi.zeta"}, then a plot of the
bootstrapped values will be produced and confidence contour lines will be
drawn for each value in level.}

\item{parallel}{if \code{TRUE}, then the package will attempt to use multiple
cores to speed up computation.}

\item{progressBar}{if \code{TRUE}, then progress bars will be displayed to
show progress on the bootstrapping.}

\item{pbopts}{a list of arguments for the \code{\link[pbapply]{pboptions}}
function that affect the progress bars. Ignored if \code{progressBar =
FALSE}.}
}
\value{
If \code{model == "zeta"}, then either a \code{vector} or a
  \code{data.frame} with elements/columns named \code{"lower"} and
  \code{"upper"} representing the lower and upper bounds of the confidence
  interval(s). Multiple bounds are returned in a \code{data.frame} when
  \code{level} has more than one value. If \code{model == "zi.zeta"}, then a
  list with length equal to the length of \code{level} is returned. The name
  of each element in the list is the level with % attached. For example if
  \code{level == 0.95}, then the list has a single element named
  \code{"95\%"}. Each element of the list consists of a \code{list} with
  elements named \code{pi} and \code{shape} which specify the coordinates of
  the contour for that level. There is a third element named \code{level}
  which gives the height of the kernel density estimate at that contour.
}
\description{
Use boostrapping to generate confidence intervals, or confidence regions in
the case of the zero-inflated model.
}
\details{
This function uses bootstrapping to compute a confidence interval
  for the shape parameter in the case of the zeta model and a confidence
  region in the case of the zero-inflated zeta model. A smoothed bootstrap
  approach is taken rather than a simple percentile method. The kernel
  density estimation is performed by the \code{ks} package using a smoothed
  cross-validated bandwidth selection procedure.
}
\section{Methods (by class)}{
\itemize{
\item \code{bootCI(default)}: Bootstrap confidence intervals or regions

\item \code{bootCI(psData)}: Bootstrap confidence intervals or regions

\item \code{bootCI(psFit)}: Bootstrap confidence intervals or regions

}}
\examples{
\dontrun{
data(Psurveys)
roux = Psurveys$roux
confRegion = bootCI(roux, model = "zi.zeta", parallel = FALSE, plot = TRUE)

## This will not work unless you have the sp package installed
## Count how many of the points lie within the 95\% confidence region
table(sp::point.in.polygon(fit$pi,fit$shape, confRegion$pi, confRegion$shape))
}
}
