% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gamma.R
\name{fitGrassiaIIBin}
\alias{fitGrassiaIIBin}
\title{Fitting the Grassia II Binomial distribution when binomial random variable,
frequency and shape parameters are given}
\usage{
fitGrassiaIIBin(x,obs.freq,a,b)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{obs.freq}{vector of frequencies.}

\item{a}{single value for shape parameter a.}

\item{b}{single value for shape parameter b.}
}
\value{
The output of \code{fitGrassiaIIBin} gives the class format \code{fitGrIIB} and \code{fit} consisting a list

\code{bin.ran.var} binomial random variables.

\code{obs.freq} corresponding observed frequencies.

\code{exp.freq} corresponding expected frequencies.

\code{statistic} chi-squared test statistics.

\code{df} degree of freedom.

\code{p.value} probability value by chi-squared test statistic.

\code{fitGrIIB} fitted values of \code{dGrassiaIIBin}.

\code{NegLL} Negative Log Likelihood value.

\code{a} estimated value for shape parameter a.

\code{b} estimated value for shape parameter b.

\code{AIC} AIC value.

\code{over.dis.para} over dispersion value.

\code{call} the inputs of the function.

Methods \code{summary}, \code{print}, \code{AIC}, \code{residuals} and \code{fitted} can be used to
extract specific outputs.
}
\description{
The function will fit the Grassia II Binomial Distribution when random variables,
corresponding frequencies and shape parameters are given. It will provide
the expected frequencies, chi-squared test statistics value, p value, degree of freedom
and over dispersion value so that it can be seen if this distribution fits the data.
}
\details{
\deqn{0 < a,b}
\deqn{x = 0,1,2,...}
\deqn{obs.freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary
error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7       #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)          #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
parameters <- EstMLEGrassiaIIBin(x=No.D.D,freq=Obs.fre.1,a=0.1,b=0.1)

aGIIBin <- bbmle::coef(parameters)[1]         #assigning the estimated a
bGIIBin <- bbmle::coef(parameters)[2]         #assigning the estimated b

#fitting when the random variable,frequencies,shape parameter values are given.
results <- fitGrassiaIIBin(No.D.D,Obs.fre.1,aGIIBin,bGIIBin)
results

#extracting the expected frequencies
fitted(results)

#extracting the residuals
residuals(results)
}
\references{
\insertRef{grassia1977family}{fitODBOD}
}
