% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BetaCorrBin.R
\name{NegLLBetaCorrBin}
\alias{NegLLBetaCorrBin}
\title{Negative Log Likelihood value of Beta-Correlated Binomial distribution}
\usage{
NegLLBetaCorrBin(x,freq,cov,a,b)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}

\item{cov}{single value for covariance.}

\item{a}{single value for alpha parameter.}

\item{b}{single value for beta parameter.}
}
\value{
The output of \code{NegLLBetaCorrBin} will produce a single numeric value.
}
\description{
This function will calculate the negative log likelihood value when the vector of binomial random
variables and vector of corresponding frequencies are given with the input parameters.
}
\details{
\deqn{freq \ge 0}
\deqn{x = 0,1,2,..}
\deqn{-\infty < cov < +\infty}
\deqn{0 < a,b}

\strong{NOTE} : If input parameters are not in given domain conditions
necessary error messages will be provided to go further.
}
\examples{
No.D.D <- 0:7         #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)      #assigning the corresponding frequencies

NegLLBetaCorrBin(No.D.D,Obs.fre.1,0.001,9.03,10)     #acquiring the negative log likelihood value

}
\references{
Paul, S.R., 1985. A three-parameter generalization of the binomial distribution. Communications in Statistics
- Theory and Methods, 14(6), pp.1497-1506.

Available at: \url{http://www.tandfonline.com/doi/abs/10.1080/03610928508828990} .
}
