% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_data_exploration.R
\name{fst_ngrams}
\alias{fst_ngrams}
\title{Find and Plot Top N-grams}
\usage{
fst_ngrams(
  data,
  number = 10,
  ngrams = 1,
  norm = "number_words",
  pos_filter = NULL,
  strict = TRUE,
  name = NULL
)
}
\arguments{
\item{data}{A dataframe of text in CoNLL-U format.}

\item{number}{The number of top words to return, default is `10`.}

\item{ngrams}{The type of n-grams, default is `1`.}

\item{norm}{The method for normalising the data. Valid settings are
`"number_words"` (the number of words in the responses, default),
`"number_resp"` (the number of responses), or `NULL` (raw count returned).}

\item{pos_filter}{List of UPOS tags for inclusion, default is `NULL` which
means all word types included.}

\item{strict}{Whether to strictly cut-off at `number` (ties are
alphabetically ordered), default is `TRUE`.}

\item{name}{An optional "name" for the plot to add to title, default is
`NULL`.}
}
\value{
Plot of top n-grams
}
\description{
Creates a plot of the most frequently-occurring n-grams within the
data.
}
\examples{
q11_1 <- conllu_dev_q11_1
fst_ngrams(q11_1, 12, ngrams = 2, norm = NULL, strict = FALSE, name = "All")
fst_ngrams(conllu_dev_q11_1_na, number = 15, ngrams = 3, name = "Not Spec")
}
