% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prefilter.R
\name{prefilter}
\alias{prefilter}
\title{Apply the "prefilter" to a Detection Dataframe}
\usage{
prefilter(jsats_file, reference_tags)
}
\arguments{
\item{jsats_file}{A dataframe which is the output from read_jstats() or
format_detects()}

\item{reference_tags}{A vector of potential reference (beacon) tag IDs}
}
\value{
A standardized detection dataframe with multipath detects removed
}
\description{
This function takes a detection dataframe output from read_jsats or from
format_detects and filters out multipath signals (time between detections
< 0.3 seconds) and spurious signals which do not occur within a specified
time frame of the last detection. For beacon tags, this time frame is 192
seconds, and for fish, this time is 120 seconds. Following this, the
dataframes are standardized so that all detection dataframes from any
technology type are identical and superfluous fields are removed.
}
\examples{
# Filter a raw detection dataset
prefilter(raw_ats, reftags)
}
