% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fire.R
\docType{class}
\name{Fire}
\alias{Fire}
\title{Generate a New App Object}
\description{
The Fire generator creates a new \code{Fire}-object, which is the class containing
all the app logic. The class is based on the \link[R6:R6Class]{R6} OO-system and
is thus reference-based with methods and data attached to each object, in
contrast to the more well known S3 and S4 systems. A \code{fiery} server is event
driven, which means that it is build up and manipulated by adding event
handlers and triggering events. To learn more about the \code{fiery} event model,
read the \href{https://fiery.data-imaginist.com/articles/events.html}{event vignette}.
\code{fiery} servers can be modified directly or by attaching plugins. As with
events, \href{https://fiery.data-imaginist.com/articles/plugins.html}{plugins has its own vignette}.
}
\section{Initialization}{

A new 'Fire'-object is initialized using the \code{new()} method on the generator:

\strong{Usage}
\tabular{l}{
\code{app <- Fire$new(host = '127.0.0.1', port = 8080L)}
}

\strong{Arguments}
\tabular{lll}{
\code{host} \tab  \tab A string overriding the default host (see the \emph{Fields} section below)\cr
\code{port} \tab  \tab An integer overriding the default port (see the \emph{Fields} section below)
}

\emph{Copying}

As \code{Fire} objects are using reference semantics new copies of an app cannot
be made simply be assigning it to a new variable. If a true copy of a \code{Fire}
object is desired, use the \code{clone()} method.
}

\section{Fields}{

\describe{
\item{\code{host}}{A string giving a valid IPv4 address owned by the server, or \code{'0.0.0.0'} to listen on all addresses. The default is \code{'127.0.0.1'}}
\item{\code{port}}{An integer giving the port number the server should listen on (defaults to \code{8080L})}
\item{\code{refresh_rate}}{The interval in seconds between run cycles when running a blocking server (defaults to \code{0.001})}
\item{\code{refresh_rate_nb}}{The interval in seconds between run cycles when running a non-bocking server (defaults to \code{1})}
\item{\code{trigger_dir}}{A valid folder where trigger files can be put when running a blocking server (defaults to \code{NULL})}
\item{\code{plugins}}{A named list of the already attached plugins. \strong{Static} - can only be modified using the \code{attach()} method.}
\item{\code{root}}{The location of the app. Setting this will remove the root value from requests (or decline them with \code{400} if the request does not match the root). E.g. the path of a request will be changed from \verb{/demo/test} to \verb{/test} if \code{root == '/demo'}}
\item{\code{access_log_format}}{A \link[glue:glue]{glue} string defining how requests will be logged. For standard formats see \link{common_log_format} and \link{combined_log_format}. Defaults to the \emph{Common Log Format}}
}
}

\section{Methods}{

\describe{
\item{\code{ignite(block = TRUE, showcase = FALSE, ...)}}{Begins the server, either blocking the console if \code{block = TRUE} or not. If \code{showcase = TRUE} a browser window is opened directing at the server address. \code{...} will be redirected to the \code{start} handler(s)}
\item{\code{start(block = TRUE, showcase = FALSE, ...)}}{A less dramatic synonym of for \code{ignite()}}
\item{\code{reignite(block = TRUE, showcase = FALSE, ...)}}{As \code{ignite} but additionally triggers the \code{resume} event after the \code{start} event}
\item{\code{resume(block = TRUE, showcase = FALSE, ...)}}{Another less dramatic synonym, this time for \code{reignite()}}
\item{\code{extinguish()}}{Stops a running server}
\item{\code{stop()}}{Boring synonym for \code{extinguish()}}
\item{\code{is_running()}}{Check if the server is currently running}
\item{\code{on(event, handler, pos = NULL)}}{Add a \code{handler} function to to an \code{event} at the given position (\code{pos}) in the handler stack. Returns a string uniquely identifying the handler. See the \href{https://fiery.data-imaginist.com/articles/events.html}{event vignette} for more information.}
\item{\code{off(handlerId)}}{Remove the handler tied to the given \code{id}}
\item{\code{trigger(event, ...)}}{Triggers an \code{event} passing the additional arguments to the potential handlers}
\item{\code{send(message, id)}}{Sends a websocket \code{message} to the client with the given \code{id}, or to all connected clients if \code{id} is missing}
\item{\code{log(event, message, request, ...)}}{Send a \code{message} to the logger. The \code{event} defines the type of message you are passing on, while \code{request} is the related \code{Request} object if applicable.}
\item{\code{close_ws_con(id)}}{Closes the websocket connection started from the client with the given \code{id}, firing the \code{websocket-closed} event}
\item{\code{attach(plugin, ..., force = FALSE)}}{Attaches a \code{plugin} to the server. See the \href{https://fiery.data-imaginist.com/articles/plugins.html}{plugin vignette} for more information. Plugins can only get attached once unless \code{force = TRUE}}
\item{\code{has_plugin(name)}}{Check whether a plugin with the given \code{name} has been attached}
\item{\code{header(name, value)}}{Add a global \code{header} to the server that will be set on all responses. Remove by setting \code{value = NULL}}
\item{\code{set_data(name, value)}}{Adds data to the servers internal data store}
\item{\code{get_data(name)}}{Extracts data from the internal data store}
\item{\code{remove_data(name)}}{Removes the data with the given \code{name} from the internal data store}
\item{\code{time(expr, then, after, loop = FALSE)}}{Add a timed evaluation (\code{expr}) that will be evaluated after the given number of seconds (\code{after}), potentially repeating if \code{loop = TRUE}. After the expression has evaluated the \code{then} function will get called with the result of the expression and the server object as arguments.}
\item{\code{remove_time(id)}}{Removes the timed evaluation identified by the \code{id} (returned when adding the evaluation)}
\item{\code{delay(expr, then)}}{Similar to \code{time()}, except the \code{expr} is evaluated immediately at the end of the loop cycle (\href{https://fiery.data-imaginist.com/articles/delayed.html}{see here} for detailed explanation of delayed evaluation in fiery).}
\item{\code{remove_delay(id)}}{Removes the delayed evaluation identified by the \code{id}}
\item{\code{async(expr, then)}}{As \code{delay()} and \code{time()} except the expression is evaluated asynchronously. The progress of evaluation is checked at the end of each loop cycle}
\item{\code{remove_async(id)}}{Removes the async evaluation identified by the \code{id}. The evaluation is not necessarily stopped but the then function will not get called.}
\item{\code{set_client_id_converter(converter)}}{Sets the function that converts an HTTP request into a specific client id}
\item{\code{set_logger(logger)}}{Sets the function that takes care of logging}
\item{\code{set_client_id_converter(converter)}}{Sets the function that converts an HTTP request into a specific client id}
\item{\code{clone()}}{Create a copy of the full \code{Fire} object and return that}
}
}

\examples{
# Create a New App
app <- Fire$new(port = 4689)

# Setup the data every time it starts
app$on('start', function(server, ...) {
    server$set_data('visits', 0)
    server$set_data('cycles', 0)
})

# Count the number of cycles
app$on('cycle-start', function(server, ...) {
    server$set_data('cycles', server$get_data('cycles') + 1)
})

# Count the number of requests
app$on('before-request', function(server, ...) {
    server$set_data('visits', server$get_data('visits') + 1)
})

# Handle requests
app$on('request', function(server, ...) {
    list(
        status = 200L,
        headers = list('Content-Type' = 'text/html'),
        body = paste('This is indeed a test. You are number', server$get_data('visits'))
    )
})

# Show number of requests in the console
app$on('after-request', function(server, ...) {
    message(server$get_data('visits'))
    flush.console()
})

# Terminate the server after 300 cycles
app$on('cycle-end', function(server, ...) {
    if (server$get_data('cycles') > 300) {
        message('Ending...')
        flush.console()
        server$extinguish()
    }
})

# Be polite
app$on('end', function(server) {
    message('Goodbye')
    flush.console()
})

\dontrun{
app$ignite(showcase = TRUE)
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Fire$new()}}
\item \href{#method-format}{\code{Fire$format()}}
\item \href{#method-ignite}{\code{Fire$ignite()}}
\item \href{#method-start}{\code{Fire$start()}}
\item \href{#method-reignite}{\code{Fire$reignite()}}
\item \href{#method-resume}{\code{Fire$resume()}}
\item \href{#method-extinguish}{\code{Fire$extinguish()}}
\item \href{#method-stop}{\code{Fire$stop()}}
\item \href{#method-on}{\code{Fire$on()}}
\item \href{#method-off}{\code{Fire$off()}}
\item \href{#method-trigger}{\code{Fire$trigger()}}
\item \href{#method-send}{\code{Fire$send()}}
\item \href{#method-close_ws_con}{\code{Fire$close_ws_con()}}
\item \href{#method-attach}{\code{Fire$attach()}}
\item \href{#method-has_plugin}{\code{Fire$has_plugin()}}
\item \href{#method-header}{\code{Fire$header()}}
\item \href{#method-set_data}{\code{Fire$set_data()}}
\item \href{#method-get_data}{\code{Fire$get_data()}}
\item \href{#method-remove_data}{\code{Fire$remove_data()}}
\item \href{#method-time}{\code{Fire$time()}}
\item \href{#method-remove_time}{\code{Fire$remove_time()}}
\item \href{#method-delay}{\code{Fire$delay()}}
\item \href{#method-remove_delay}{\code{Fire$remove_delay()}}
\item \href{#method-async}{\code{Fire$async()}}
\item \href{#method-remove_async}{\code{Fire$remove_async()}}
\item \href{#method-set_client_id_converter}{\code{Fire$set_client_id_converter()}}
\item \href{#method-set_logger}{\code{Fire$set_logger()}}
\item \href{#method-log}{\code{Fire$log()}}
\item \href{#method-is_running}{\code{Fire$is_running()}}
\item \href{#method-test_request}{\code{Fire$test_request()}}
\item \href{#method-test_header}{\code{Fire$test_header()}}
\item \href{#method-test_message}{\code{Fire$test_message()}}
\item \href{#method-test_websocket}{\code{Fire$test_websocket()}}
\item \href{#method-clone}{\code{Fire$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$new(host = "127.0.0.1", port = 8080)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-format"></a>}}
\if{latex}{\out{\hypertarget{method-format}{}}}
\subsection{Method \code{format()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$format(...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ignite"></a>}}
\if{latex}{\out{\hypertarget{method-ignite}{}}}
\subsection{Method \code{ignite()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$ignite(block = TRUE, showcase = FALSE, ..., silent = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-start"></a>}}
\if{latex}{\out{\hypertarget{method-start}{}}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$start(block = TRUE, showcase = FALSE, ..., silent = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reignite"></a>}}
\if{latex}{\out{\hypertarget{method-reignite}{}}}
\subsection{Method \code{reignite()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$reignite(block = TRUE, showcase = FALSE, ..., silent = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resume"></a>}}
\if{latex}{\out{\hypertarget{method-resume}{}}}
\subsection{Method \code{resume()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$resume(block = TRUE, showcase = FALSE, ..., silent = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-extinguish"></a>}}
\if{latex}{\out{\hypertarget{method-extinguish}{}}}
\subsection{Method \code{extinguish()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$extinguish()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stop"></a>}}
\if{latex}{\out{\hypertarget{method-stop}{}}}
\subsection{Method \code{stop()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$stop()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-on"></a>}}
\if{latex}{\out{\hypertarget{method-on}{}}}
\subsection{Method \code{on()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$on(event, handler, pos = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-off"></a>}}
\if{latex}{\out{\hypertarget{method-off}{}}}
\subsection{Method \code{off()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$off(handlerId)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trigger"></a>}}
\if{latex}{\out{\hypertarget{method-trigger}{}}}
\subsection{Method \code{trigger()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$trigger(event, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-send"></a>}}
\if{latex}{\out{\hypertarget{method-send}{}}}
\subsection{Method \code{send()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$send(message, id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-close_ws_con"></a>}}
\if{latex}{\out{\hypertarget{method-close_ws_con}{}}}
\subsection{Method \code{close_ws_con()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$close_ws_con(id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-attach"></a>}}
\if{latex}{\out{\hypertarget{method-attach}{}}}
\subsection{Method \code{attach()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$attach(plugin, ..., force = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-has_plugin"></a>}}
\if{latex}{\out{\hypertarget{method-has_plugin}{}}}
\subsection{Method \code{has_plugin()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$has_plugin(name)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-header"></a>}}
\if{latex}{\out{\hypertarget{method-header}{}}}
\subsection{Method \code{header()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$header(name, value)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_data"></a>}}
\if{latex}{\out{\hypertarget{method-set_data}{}}}
\subsection{Method \code{set_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$set_data(name, value)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-get_data}{}}}
\subsection{Method \code{get_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$get_data(name)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove_data"></a>}}
\if{latex}{\out{\hypertarget{method-remove_data}{}}}
\subsection{Method \code{remove_data()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$remove_data(name)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-time"></a>}}
\if{latex}{\out{\hypertarget{method-time}{}}}
\subsection{Method \code{time()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$time(expr, then, after, loop = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove_time"></a>}}
\if{latex}{\out{\hypertarget{method-remove_time}{}}}
\subsection{Method \code{remove_time()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$remove_time(id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delay"></a>}}
\if{latex}{\out{\hypertarget{method-delay}{}}}
\subsection{Method \code{delay()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$delay(expr, then)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove_delay"></a>}}
\if{latex}{\out{\hypertarget{method-remove_delay}{}}}
\subsection{Method \code{remove_delay()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$remove_delay(id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-async"></a>}}
\if{latex}{\out{\hypertarget{method-async}{}}}
\subsection{Method \code{async()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$async(expr, then)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-remove_async"></a>}}
\if{latex}{\out{\hypertarget{method-remove_async}{}}}
\subsection{Method \code{remove_async()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$remove_async(id)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_client_id_converter"></a>}}
\if{latex}{\out{\hypertarget{method-set_client_id_converter}{}}}
\subsection{Method \code{set_client_id_converter()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$set_client_id_converter(converter)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_logger"></a>}}
\if{latex}{\out{\hypertarget{method-set_logger}{}}}
\subsection{Method \code{set_logger()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$set_logger(logger)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log"></a>}}
\if{latex}{\out{\hypertarget{method-log}{}}}
\subsection{Method \code{log()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$log(event, message, request = NULL, ...)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-is_running"></a>}}
\if{latex}{\out{\hypertarget{method-is_running}{}}}
\subsection{Method \code{is_running()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$is_running()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-test_request"></a>}}
\if{latex}{\out{\hypertarget{method-test_request}{}}}
\subsection{Method \code{test_request()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$test_request(request)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-test_header"></a>}}
\if{latex}{\out{\hypertarget{method-test_header}{}}}
\subsection{Method \code{test_header()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$test_header(request)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-test_message"></a>}}
\if{latex}{\out{\hypertarget{method-test_message}{}}}
\subsection{Method \code{test_message()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$test_message(request, binary, message, withClose = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-test_websocket"></a>}}
\if{latex}{\out{\hypertarget{method-test_websocket}{}}}
\subsection{Method \code{test_websocket()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$test_websocket(request, message, close = TRUE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Fire$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
