% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_entries.R
\name{fhir_common_columns}
\alias{fhir_common_columns}
\title{Find common columns}
\usage{
fhir_common_columns(data_frame, column_names_prefix)
}
\arguments{
\item{data_frame}{A data.frame/data.table with automatically named columns as produced by \code{\link[=fhir_crack]{fhir_crack()}}.}

\item{column_names_prefix}{A string containing the common prefix of the desired columns.}
}
\value{
A character vector with the names of all columns matching \code{column_names_prefix}.
}
\description{
This is a convenience function to find all column names in a data frame starting with the same string that can
then be used for \code{\link[=fhir_melt]{fhir_melt()}}.
}
\details{
It is intended for use on data frames with column names that have been automatically produced by \code{\link[=fhir_design]{fhir_design()}}/\code{\link[=fhir_crack]{fhir_crack()}}
and follow the form \code{level1.level2.level3} such as \code{name.given} or \code{code.coding.system}.
Note that this function will only work on column names following exactly this scheme.

The resulting character vector can be used for melting all columns belonging to the same attribute in an indexed data frame,
see \code{?fhir_melt}.
}
\examples{
#unserialize example bundles
bundles <- fhir_unserialize(bundles = medication_bundles)

#crack Patient Resources
pats <- fhir_table_description(resource = "Patient")

df <- fhir_crack(bundles = bundles, design = pats)

#look at automatically generated names
names(df)

#extract all column names beginning with the string "name"
fhir_common_columns(data_frame = df, column_names_prefix = "name")
}
\seealso{
\code{\link[=fhir_melt]{fhir_melt()}}, \code{\link[=fhir_rm_indices]{fhir_rm_indices()}}
}
