% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_entries.R
\name{fhir_melt}
\alias{fhir_melt}
\title{Melt multiple entries}
\usage{
fhir_melt(
  indexed_data_frame,
  columns,
  brackets = c("<", ">"),
  sep = " ",
  id_name = "resource_identifier",
  all_columns = FALSE
)
}
\arguments{
\item{indexed_data_frame}{A data.frame/data.table with indexed multiple entries.}

\item{columns}{A character vector specifying the names of all columns that should be molten simultaneously.
It is advisable to only melt columns simultaneously that belong to the same (repeating) attribute!}

\item{brackets}{A character vector of length two, defining the brackets used for the indices.}

\item{sep}{A character vector of length one defining the separator that was used when pasting together multiple entries in \code{\link[=fhir_crack]{fhir_crack()}}.}

\item{id_name}{A character vector of length one, the name of the column that will hold the identification of the origin of the new rows.}

\item{all_columns}{Return all columns? Defaults to \code{FALSE}, meaning only those specified in \code{columns} are returned.}
}
\value{
A data.frame/data.table where each entry from the variables in \code{columns} appears in a separate row.
}
\description{
This function divides multiple entries in an indexed data frame as produced by \code{\link[=fhir_crack]{fhir_crack()}}.
into separate rows.
}
\details{
Every row containing values that consist of multiple entries on the variables specified by the argument \code{columns}
will be turned into multiple rows, one for each entry. Values on other variables will be repeated in all the new rows.

The new data.frame will contain only the molten variables (if \code{all_cloumns = FALSE}) or all variables
(if \code{all_columns = TRUE}) as well as an additional variable \code{resource_identifier} that maps which rows came
from the same origin. The name of this column can be changed in the argument \code{id_name}.

For a more detailed description on how to use this function please see the corresponding package vignette.
}
\examples{
#unserialize example
bundles <- fhir_unserialize(bundles = example_bundles1)

#crack fhir resources
table_desc <- fhir_table_description(resource = "Patient",
                                     style = fhir_style(brackets = c("[","]"),
                                                        sep = " "))
df <- fhir_crack(bundles = bundles, design = table_desc)

#find all column names associated with attribute address
col_names <- fhir_common_columns(df, "address")

#original data frame
df

#only keep address columns
fhir_melt(indexed_data_frame = df, columns = col_names,
          brackets = c("[","]"), sep = " ")

#keep all columns
fhir_melt(indexed_data_frame = df, columns = col_names,
          brackets = c("[","]"), sep = " ", all_columns = TRUE)
}
\seealso{
\code{\link[=fhir_common_columns]{fhir_common_columns()}}, \code{\link[=fhir_rm_indices]{fhir_rm_indices()}}
}
