% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\docType{data}
\name{patient_bundles}
\alias{patient_bundles}
\title{Exemplary FHIR bundles}
\format{
List of length 2 containing \emph{serialized} "xml_document" objects, each representing one bundle from a
FHIR search request. \emph{They have to be unserialized before use, see Examples!}
}
\source{
Generated by:

\code{fhir_search(request="http://fhir.hl7.de:8080/baseDstu3/Patient?", max_bundles=2)}

[Downloaded 07-07-20]
}
\usage{
patient_bundles
}
\description{
This data example can be used to explore some of the functions from the fhircrackr package
when direct access to a FHIR server is not possible.
}
\details{
patient_bundles is a list of \emph{serialized} xml objects representing FHIR bundles as returned by fhir_search().

It contains 2 bundles with Patient resources.
}
\examples{
#unserialize xml objects before doing anything else with them!
patient_bundles <- fhir_unserialize(patient_bundles)


}
\keyword{datasets}
