% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\name{fhir_save}
\alias{fhir_save}
\title{Save FHIR bundles as xml-files}
\usage{
fhir_save(bundles, directory = "result")
}
\arguments{
\item{bundles}{A list of xml objects representing the FHIR bundles.}

\item{directory}{A string containing the path to the folder to store the data in.}
}
\description{
Writes a list of FHIR bundles as numbered xml files into a directory.
}
\examples{
#unserialize example bundle
bundles <- fhir_unserialize(medication_bundles)

#save to temporary directory
fhir_save(bundles, directory = tempdir())
}
