% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{initFFFMeanCD}
\alias{initFFFMeanCD}
\title{Initialisation of FFF mean change detector}
\usage{
initFFFMeanCD(alpha, lambda = 1, BL = 50)
}
\arguments{
\item{alpha}{The value of the significance level. There is
no default value on purpose - it must be set
by the user.}

\item{lambda}{The value of the fixed forgetting factor. 
Default value is \code{lambda=1}.}

\item{BL}{The length of the burn-in region. Default value is \code{BL=50}.}
}
\description{
This function makes it simple to initalise an FFF object.
}
\examples{
library(Rcpp)
fffcd1 <- initFFFMeanCD(0.99, 0.95)     # initialises with alpha=0.99
                                        # and lambda=0.95 (and BL=50)
}

