% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_ff_simulate_week.R
\name{ff_simulate_week}
\alias{ff_simulate_week}
\title{Simulate Fantasy Week}
\usage{
ff_simulate_week(
  conn,
  n = 1000,
  best_ball = FALSE,
  seed = NULL,
  base_seasons = 2012:2020,
  actual_schedule = TRUE,
  replacement_level = FALSE,
  pos_filter = c("QB", "RB", "WR", "TE", "K"),
  verbose = NULL,
  return = c("default", "all")
)
}
\arguments{
\item{conn}{an connection to a league made with \code{ff_connect()} and friends (required)}

\item{n}{number of times to simulate the upcoming week, default is 1000}

\item{best_ball}{a logical: are weekly wins based on optimal lineups?}

\item{seed}{an integer to control reproducibility}

\item{base_seasons}{a numeric vector that selects seasons as base data, earliest available is 2012}

\item{actual_schedule}{a logical: use actual ff_schedule? default is TRUE}

\item{replacement_level}{a logical: use best available on waiver as  replacement level? defaults to FALSE for upcoming week simulations}

\item{pos_filter}{a character vector of positions to filter/run, default is c("QB","RB","WR","TE","K")}

\item{verbose}{a logical: print status messages? default is TRUE, configure with options(ffsimulator.verbose)}

\item{return}{one of c("default", "all") - what objects to return in the output list}
}
\value{
an \code{ff_simulation} object which can be passed to \code{plot()} and contains the output data from the simulation.
}
\description{
This function simulates a single upcoming week using the same methodology as in the season-long simulation, \code{ff_simulate()}.
}
\examples{
\donttest{
try({ # try block to prevent CRAN-related issues
conn <- mfl_connect(2021, 22627)
ff_simulate_week(conn, n = 1000, actual_schedule = TRUE)
})
}

}
\seealso{
\code{vignette("basic")} for example usage

\code{vignette("custom")} for examples on using the subfunctions for your own processes.
}
