% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/views.R
\name{view_on_covariance}
\alias{view_on_covariance}
\alias{view_on_covariance.default}
\alias{view_on_covariance.matrix}
\alias{view_on_covariance.xts}
\alias{view_on_covariance.tbl_df}
\title{Views on the Covariance Matrix}
\usage{
view_on_covariance(x, mean, sigma)

\method{view_on_covariance}{default}(x, mean, sigma)

\method{view_on_covariance}{matrix}(x, mean, sigma)

\method{view_on_covariance}{xts}(x, mean, sigma)

\method{view_on_covariance}{tbl_df}(x, mean, sigma)
}
\arguments{
\item{x}{An univariate or a multivariate distribution.}

\item{mean}{A \code{double} for the location parameter of the series in \code{x}.}

\item{sigma}{A \code{matrix} for the target variance-covariance parameter
of the series in \code{x}.}
}
\value{
A \code{list} of the \code{view} class.
}
\description{
Helper to construct views on variance-covariance matrix.
}
\examples{
library(ggplot2)

# Invariant (stationarity)
ret <- diff(log(EuStockMarkets))

# Expectations for location and dispersion parameters
mean <- colMeans(ret) # No active expectations for returns
covs <- matrix(0, ncol = 4, nrow = 4) # assuming all assets are uncorrelated
                                      # very strong view!

# prior probabilities (usually equal weight scheme)
prior <- rep(1 / nrow(ret), nrow(ret))

# Views
views <- view_on_covariance(x = ret, mean = mean, sigma = covs)
views

# Optimization
ep <- entropy_pooling(p = prior, Aeq = views$Aeq, beq = views$beq, solver = "nlminb")
autoplot(ep)

# original covariance matrix
stats::cov(ret)

# Posterior covariance matrix
ffp_moments(x = ret, p = ep)$sigma
}
\keyword{internal}
