% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty-rfpl.R
\name{uncertainty_rfpl}
\alias{uncertainty_rfpl}
\title{Regula-Falsi Profile Likelihood Uncertainty Quantification}
\usage{
uncertainty_rfpl(
  data,
  distribution,
  ns_years = NULL,
  ns_structure = NULL,
  ns_slices = NULL,
  alpha = 0.05,
  periods = c(2, 5, 10, 20, 50, 100),
  tolerance = 0.01
)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{distribution}{A three-character code indicating the distribution family.
Must be \code{"GUM"}, \code{"NOR"}, \code{"LNO"}, \code{"GEV"}, \code{"GLO"}, \code{"GNO"}, \code{"PE3"}, \code{"LP3"},
or \code{"WEI"}.}

\item{ns_years}{For NS-FFA only: Numeric vector of observation years corresponding
to \code{data}. Must be the same length as \code{data} and strictly increasing.}

\item{ns_structure}{For NS-FFA only: Named list indicating which distribution
parameters are modeled as nonstationary. Must contain two logical scalars:
\itemize{
\item \code{location}: If \code{TRUE}, the location parameter has a linear temporal trend.
\item \code{scale}: If \code{TRUE}, the scale parameter has a linear temporal trend.
}}

\item{ns_slices}{For NS-FFA only: Numeric vector specifying the years at which to
evaluate the return levels confidence intervals of a nonstationary probability
distribution. \code{ns_slices} do not have to be elements of the \code{ns_years} argument.}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}

\item{periods}{Numeric vector used to set the return periods for FFA.
All entries must be greater than or equal to 1.}

\item{tolerance}{The log-likelihood tolerance for Regula-Falsi convergence
(default is 0.01).}
}
\value{
A list containing the following four items:
\itemize{
\item \code{method}: "RFPL"
\item \code{distribution}: The \code{distribution} argument.
\item \code{params}: The fitted parameters.
\item \code{ns_structure}: The \code{ns_structure} argument, if given.
\item \code{ns_slices}: The \code{ns_slices} argument, if given.
\item \code{ci}: A dataframe containing confidence intervals (S-FFA only)
\item \code{ci_list}: A list of dataframes containing confidence intervals (NS-FFA only).
}

The dataframe(s) in \code{ci} and \code{ci_list} have four columns:
\itemize{
\item \code{estimates}: Estimated quantiles for each return period.
\item \code{lower}: Lower bound of the confidence interval for each return period.
\item \code{upper}: Upper bound of the confidence interval for each return period.
\item \code{periods}: The \code{periods} argument.
}
}
\description{
Calculates return level estimates and confidence intervals at specified return
periods (defaults to 2, 5, 10, 20, 50, and 100 years) using the regula-falsi profile
likelihood root‐finding method.

\strong{For NS-FFA}: To perform uncertainty quantification for a nonstationary model,
include the observation years (\code{ns_years}), the nonstationary model structure
(\code{ns_structure}), and a list of years at which to compute the return level estimates
and confidence intervals (\code{ns_slices}).
}
\details{
\enumerate{
\item Uses \code{\link[=fit_mle]{fit_mle()}} to obtain the maximum log‐likelihood.
\item Defines an objective function \eqn{f(y_p, p)} by reparameterizing the
log-likelihood.
\item Iteratively brackets the root by rescaling initial guesses by 0.05 until
\eqn{f(y_p, p)} changes sign.
\item Uses the regula-falsi method to solve \eqn{f(y_p, p) = 0} for each
return period probability.
\item Returns lower and upper confidence bounds at significance level \code{alpha}.
}
}
\note{
RFPL uncertainty quantification can be numerically unstable for some datasets.
If this function encounters an issue, it will return an error and recommend
using the parametric bootstrap method \code{\link[=uncertainty_bootstrap]{uncertainty_bootstrap()}} instead.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
uncertainty_rfpl(data, "GLO")

}
\references{
Vidrio-Sahagún, C.T., He, J. Enhanced profile likelihood method for the nonstationary
hydrological frequency analysis, Advances in Water Resources 161, 10451 (2022).
\doi{10.1016/j.advwatres.2022.104151}

Vidrio-Sahagún, C.T., He, J. & Pietroniro, A. Multi-distribution regula-falsi profile
likelihood method for nonstationary hydrological frequency analysis. Stochastic Environmental
Research and Risk Assessment 38, 843–867 (2024). \doi{10.1007/s00477-023-02603-0}
}
\seealso{
\code{\link[=utils_quantiles]{utils_quantiles()}}, \code{\link[=uncertainty_bootstrap]{uncertainty_bootstrap()}}, \code{\link[=uncertainty_rfgpl]{uncertainty_rfgpl()}},
\code{\link[=plot_sffa_estimates]{plot_sffa_estimates()}}, \code{\link[=plot_nsffa_estimates]{plot_nsffa_estimates()}}
}
