% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda-sens-trend.R
\name{eda_sens_trend}
\alias{eda_sens_trend}
\title{Sen's Trend Estimator}
\usage{
eda_sens_trend(data, years)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{years}{Numeric vector of observation years corresponding to \code{data}.
Must be the same length as \code{data} and strictly increasing.}
}
\value{
A list containing the estimated trend:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{years}: The \code{years} argument.
\item \code{slope}: The estimated slope.
\item \code{intercept}: The estimated y-intercept.
\item \code{residuals}: Vector of differences between the predicted and observed values.
}
}
\description{
Computes Sen's linear trend estimator for a univariate time series. The estimated
slope and y-intercept are given in terms of the data and the \emph{covariate} (time),
which is derived from the years using the formula \eqn{(\text{Years} - 1900) / 100}.
}
\details{
Sen's slope estimator is a robust, nonparametric trend estimator based on the
median of all pairwise slopes between data points. The corresponding intercept
is the median of each \eqn{y_i - mx_i} where \eqn{m} is the estimated slope.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
years <- seq(from = 1901, to = 2000)
eda_sens_trend(data, years)

}
\references{
Sen, P.K. (1968). Estimates of the regression coefficient based on Kendall's tau.
\emph{Journal of the American Statistical Association}, 63(324), 1379–1389.
}
\seealso{
\code{\link[=eda_runs_test]{eda_runs_test()}}, \code{\link[=plot_ams_data]{plot_ams_data()}}
}
