% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standard.R
\name{standard}
\alias{standard}
\title{Get \emph{standard} table}
\usage{
standard(table, variable, unit, precision, expr)
}
\arguments{
\item{table}{(optional) Character string indicating a table, i.e. the \emph{layer} table, \code{"camada"}, or the
\emph{observation} table, \code{"observacao"}.}

\item{variable}{(optional) Character vector indicating one or more variables. Accepts both specific
identification codes, e.g. \code{"ferro_oxalato_icpoes"} and \code{"carbono_cromo_30min150_mohr"}, as well as
general identification codes, e.g. \code{"ferro"} and \code{"carbono"}.}

\item{unit}{(optional) Character vector indicating one or more measurement units. For example, \code{"g/kg"},
\code{"g/cm^3"}, and \code{"cmolc/kg"}.}

\item{precision}{(optional) Integer vector indicating one or more number of decimal places.}

\item{expr}{(optional) Character string to be parsed and evaluated as a regular expression. For example,
\code{"campo_precisao > 0"}. Usage requires some knowledge of the structure of the \emph{standard} table.}
}
\value{
A data frame with standards for selected variable(s).
}
\description{
Download data from the standard ("febr-padrao") table of the Free Brazilian Repository for Open Soil Data

\emph{\strong{febr}}, \url{http://www.ufsm.br/febr}. This includes codes and names of variable, measurement units,
number of decimal places, type of data, and description of analytical methods. This is used to standardize
the data contained in a dataset when downloading it via \code{\link[febr]{layer}} or
\code{\link[febr]{observation}}.
}
\examples{
res <- standard(variable = "ferro")
head(res)
}
\references{
Teixeira, P. C., Donagemma, G. K., Fontana, A., Teixeira, W. G. (2017)
\emph{Manual de Métodos de Análise de Solo}. Brasília: Embrapa.
}
\seealso{
The \emph{standard} table at \url{https://goo.gl/hi77sB}
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
