#Português
#Descrição: Esta função serve de auxilio para a função check_diametric_increase, a mesma gera o gráfico baseado nas listas criadas pela função mount_list
#Parametros: lista de colunas a serem plotadas(list), um título para o gráfico (my_title), nome para o gráfico (name), valor de teto, ou valor máximo (ceil) para variável de plotagem no eixo y
#Exemplo de chamada: plot_cols(listaColunas,"parcela 356","parcela356plot",400)
#' @title plot_cols
#' @description This function serves as a help for the check_diametric_increase function, it generates a chart based on the lists created by the mount_list function
#' @param list, list of columns generated by function mount_list with values and colors to be ploted
#' @param my_title, string with the name you want for the title of chart
#' @param name, string name with the name you want for the file png chart
#' @param ceil, the maximum value to axis, this value will be applied in NHa or N
#' @import data.table
#' @import ggplot2
#' @export
plot_cols = function(list,name,my_title,ceil = NaN){
	graphic = NULL
  a = list
  x  = NULL
  df = data.frame()
  
  if(length(names(a)) >= 1)
  for(i in 1:length(names(a)))
    if(length(a[[i]] > 0))
    for(cor in 1:length(a[[i]]))
      df = rbind(df, data.frame(j= list(1:a[[i]][[cor]])[[1]],  x = names(a)[[i]], cor = names(a[[i]])[[cor]]))
  
  cs = unique(df$cor)
  if(length(cs) >= 1){
    s ="c("
    for(i in 1:length(cs)){
      if (i > 1)
        s = paste0(s, ", ")
      s = paste0(s, "\"", cs[[i]], "\"=\"", cs[[i]], "\"")
      
    }
    s = paste0(s, ")")
    s = eval(parse(text = s)) 
    graphic = ggplot(df, aes(x, fill=cor))  + geom_bar()  + scale_fill_manual(values = s) + labs(x = "Diametric Classes (cm)", y = "N/ha", title = my_title) + guides(fill = F)
    
    
    if(!is.nan(ceil))
      graphic = graphic + scale_y_continuous(  limits = c(0, ceil))
    
    
    if (!is.null(name)) {
      dir.create(name)
      diretorio = NULL
      diretorio = paste(getwd(),"/",name,"/",sep="")
      ggsave(paste0(diretorio,name, ".png"), plot = graphic)
      eval(parse(text = paste0("assign(\"", name, 
                               "\", graphic, envir = as.environment(1))")))
      print(paste0("use ", name, " in plot to show the graphic example: plot(",name,")"))
    }
    
    
  }
  return(graphic)
  
}