% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DenseProductFPCA.R
\name{DenseProductFPCA}
\alias{DenseProductFPCA}
\title{Product Functional Principal Component Analysis for dense repeated functional data.}
\usage{
DenseProductFPCA(
  X.age.year,
  n,
  num.years,
  num.ages,
  fpca.op1 = list(),
  fpca.op2 = list(),
  pc.j = NULL,
  pc.k = NULL
)
}
\arguments{
\item{X.age.year}{An n by (num.years x num.ages) input data matrix, such that the ith row of the matrix gives the observed values for the ith individual. The values in each row are sorted first by years (dimension 1) and then by ages (dimension 2) within each year.}

\item{n}{The sample size.}

\item{num.years}{Dimension 1}

\item{num.ages}{Dimension 2}

\item{fpca.op1}{A list of options control parameters specified by \code{list(name=value)} for FPCA in direction of (age) dimension 2; check fdapace::FPCA for available control options and default settings.}

\item{fpca.op2}{A list of options control parameters specified by \code{list(name=value)} for FPCA in direction of (year) dimension 1; check fdapace::FPCA for available control options and default settings.}

\item{pc.j}{A scalar denoting the maximum number of components to consider for FPCA in direction of (age) dimension 2; default: chosen by FVE if NULL.}

\item{pc.k}{A scalar denoting the maximum number of components to consider for FPCA in direction of (year) dimension 1; default: chosen by FVE if NULL.}
}
\value{
A list containing the following fields:
\item{Xest}{An n by (num.years x num.ages) estimated matrix, based on the fitted Product FPCA model. The ith row of the matrix gives the observed values for the ith individual. The values in each row are sorted first by years (dimension 1) and then by ages (dimension 2) within each year.}
\item{mu}{An num.ages by num.years matrix containing the bivariate mean function estimate.}
\item{pc.j}{A scalar denoting the selected number of components for FPCA in direction of (age) dimension 2.}
\item{pc.k}{A scalar denoting the selected number of components for FPCA in direction of (year) dimension 1.}
\item{scores}{An n by (pc.k x pc.j) matrix of the estimated scores, such that the ith row of the matrix comprises estimated scores \eqn{chi_{1,1}}, \eqn{chi_{1,2}},...\eqn{chi_{1,pc.k}}, \eqn{chi_{2,1}}, \eqn{chi_{2,2}}, ..., \eqn{chi_{2,pc.k}}, ..., \eqn{chi_{pc.j,1}}, \eqn{chi_{pc.j,2}}, ..., \eqn{chi_{pc.j,pc.k}} for the ith individual.}
\item{res.psi}{A list containing the FPCA output for FPCA in direction of (age) dimension 2.}
\item{res.phi}{A list containing the FPCA output for FPCA in direction of (year) dimension 1.}
\item{eig}{An (num.years x num.ages) by (pc.k x pc.j) matrix of the estimated product eigen functions. The rows are sorted first by years (dimension 1) and then by ages (dimension 2) within each year. The columns are sorted as in the scores.}
\item{psi}{An num.ages by pc.j matrix containing the estimated eigenfunctions from FPCA in direction of (age) dimension 2.}
\item{phi}{An num.years by pc.k matrix containing the estimated eigenfunctions from FPCA in direction of (year) dimension 1.}
\item{FVE}{A vector of length (pc.k x pc.j), indicating the fraction of total variance explained by each product function, with corresponding 'FVEthreshold'.}
\item{VarOrdered}{Variance explained by each term. The terms are ordered by \eqn{var(chi_{jk})}. One can select the best model by truncating at a desired level of FVE, and use names(VarOrdered) to see the corresponding model terms.}
}
\description{
Note: The code works for dense functional data observed on a regular grid, missing values are allowed, written by Kehui Chen 10/09/2015, based on the original code by Pedro Delicado.
}
\details{
The code works for dense functional data (with missing values), with density in both the direction of (age) dimension 2 and (year) dimension 1.
}
\examples{
\donttest{
n <- 100 ### sample size
N <- 100
num.ages <- 20 ### dimension 2
num.years <- 15 ### dimension 1
dense_grid <- seq(0,1,length=N)
Lt <- list()
Ly <- list()
 Lt <- lapply(1:n, function(i) dense_grid)
 Ly <- lapply(Lt, function(grid) {
 y_temp <- matrix(0, num.ages, num.years)
  lapply(1:num.ages, function(s) {
    lapply(1:num.years, function(t) {
      y_temp[s, t] <<- y_temp[s, t] + cos(grid[t]) + rnorm(1, 0, 0.5)
    })
  })
  y_temp
 })
X.age.year <- matrix(0,n,num.years*num.ages)
lapply(1:n, function(i) {
  X.age.year[i,] <<- as.vector(Ly[[i]])
})
res<-DenseProductFPCA(X.age.year, n, 15, 20, fpca.op1=NULL, fpca.op2=NULL, pc.j = NULL, pc.k = NULL)
# Basic output
res$Xest
res$mu
res$pc.j
res$pc.k
res$scores
res$res.psi
res$psi
res$FVE
res$VarOrdered
}

}
\references{
\itemize{
\item \cite{Chen, K., Delicado, P., & Müller, H. G. (2017). Modelling function-valued stochastic processes, with applications to fertility dynamics. Journal of the Royal Statistical Society Series B: Statistical Methodology, 79(1), 177-196.}
\item \cite{Chen, K., & Müller, H. G. (2012). Modeling repeated functional observations. Journal of the American Statistical Association, 107(500), 1599-1609.}
\item \cite{Hall, P.,  Müller, H.G. and Wang, J.L. (2006). Properties of principal component methods for functional and longitudinal data analysis. Annals of Statistics, 34(3), 1493-1517.}
\item \cite{Yao, F., Müller, H. G., & Wang, J. L. (2005). Functional data analysis for sparse longitudinal data. Journal of the American statistical association, 100(470), 577-590.}
}
}
