% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lqd2dens.R
\name{lqd2dens}
\alias{lqd2dens}
\title{Function for converting log quantile densities to densities}
\usage{
lqd2dens(
  lqd,
  lqdSup = seq(0, 1, length.out = length(lqd)),
  dSup,
  useSplines = TRUE
)
}
\arguments{
\item{lqd}{log quantile density on lqdSup}

\item{lqdSup}{support forlqd domain - must begin at 0 and end at 1}

\item{dSup}{support for Density domain - max and min values mark the boundary of the support.}

\item{useSplines}{fit spline to the lqd when doing the numerical integration (default: TRUE)}
}
\value{
dens density values on dSup
}
\description{
Function for converting log quantile densities to densities
}
\examples{
x <- seq(0,2,length.out =512)
y.lqd <- rep(log(2), times = 512)
y <- lqd2dens(dSup=x, lqd = y.lqd) # should equate # 1/2
}
\references{
\cite{Functional Data Analysis for Density Functions by Transformation to a Hilbert space, Alexander Petersen and Hans-Georg Mueller, 2016}
}
