% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FEMobjects.R
\name{FEM}
\alias{FEM}
\title{Define a surface or spatial field by a Finite Element basis expansion}
\usage{
FEM(coeff,FEMbasis)
}
\arguments{
\item{coeff}{A vector or a matrix containing the coefficients for the Finite Element basis expansion. The number of rows 
(or the vector's length) corresponds to the number of basis in \code{FEMbasis}. 
The number of columns corresponds to the number of functions.}

\item{FEMbasis}{A \code{FEMbasis} object defining the Finite Element basis, created by \link{create.FEM.basis}.}
}
\value{
An \code{FEM} object. This contains a list with components \code{coeff} and \code{FEMbasis}.
}
\description{
This function defines a FEM object.
}
\examples{
library(fdaPDE)
## Upload the horseshoe2D data
data(horseshoe2D)
boundary_nodes = horseshoe2D$boundary_nodes
boundary_segments = horseshoe2D$boundary_segments
locations = horseshoe2D$locations

## Create the 2D mesh
mesh = create.mesh.2D(nodes = rbind(boundary_nodes, locations), segments = boundary_segments)
## Create the FEM basis
FEMbasis = create.FEM.basis(mesh)
## Compute the coeff vector evaluating the desired function at the mesh nodes
## In this case we consider the fs.test() function introduced by Wood et al. 2008
coeff = fs.test(mesh$nodes[,1], mesh$nodes[,2])
## Create the FEM object
FEMfunction = FEM(coeff, FEMbasis)
## Plot it
plot(FEMfunction)
}
