% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.fregre.fr.r
\name{predict.fregre.fr}
\alias{predict.fregre.fr}
\title{Predict method for functional response model}
\usage{
\method{predict}{fregre.fr}(object, new.fdataobj = NULL, ...)
}
\arguments{
\item{object}{\code{fregre.fr} object.}

\item{new.fdataobj}{New functional explanatory data of \code{fdata} class.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Return the predicted functional data.
}
\description{
Computes predictions for regression between functional explanatory variables
and functional response.
}
\examples{
\dontrun{ 
# CV prediction for CandianWeather data
rtt<-c(0, 365)
basiss  <- create.bspline.basis(rtt,7)
basist  <- create.bspline.basis(rtt,9)
nam<-dimnames(CanadianWeather$dailyAv)[[2]]

# fdata class (raw data)
tt<-1:365
tempfdata<-fdata(t(CanadianWeather$dailyAv[,,1]),tt,rtt)
log10precfdata<-fdata(t(CanadianWeather$dailyAv[,,3]),tt,rtt)
rng<-range(log10precfdata) 
for (ind in 1:35){
 res1<-  fregre.basis.fr(tempfdata[-ind], log10precfdata[-ind],
 basis.s=basiss,basis.t=basist)
 pred1<-predict(res1,tempfdata[ind])
 plot( log10precfdata[ind],col=1,ylim=rng,main=nam[ind])
 lines(pred1,lty=2,col=2)
 Sys.sleep(1)
}

# fd class  (smooth data)
basis.alpha  <- create.constant.basis(rtt)
basisx  <- create.bspline.basis(rtt,65)

dayfd<-Data2fd(day.5,CanadianWeather$dailyAv,basisx)
tempfd<-dayfd[,1]
log10precfd<-dayfd[,3]
for (ind in 1:35){
 res2 <-  fregre.basis.fr(tempfd[-ind], log10precfd[-ind],
 basis.s=basiss,basis.t=basist)
 pred2<-predict(res2,tempfd[ind])
 plot(log10precfd[ind],col=1,ylim=range(log10precfd$coef),main=nam[ind]) 
 lines(pred2,lty=2,col=2)
 Sys.sleep(.5)
}
}

}
\seealso{
See Also as: \code{\link{fregre.basis.fr}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@usc.es}
}
\keyword{regression}
