% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basis_functions.R
\name{make.fourier.basis}
\alias{make.fourier.basis}
\title{Make fourier basis}
\usage{
make.fourier.basis(range, order, use.trig.id = FALSE)
}
\arguments{
\item{range}{Left and right end points.}

\item{order}{Order of harmonics}

\item{use.trig.id}{Use trigonometrical identities with this function?}
}
\value{
Function of class "fctbasis"
}
\description{
Make fourier basis
}
\details{
The number of basis elements (degrees of freedom) is 2 * order + 1.

The basis functions are ordered [1, sin(t), cos(t), sin(2t), cos(2t), ...]

Using trigonometrical identities is faster, but introduces (negligible) round-off errors.
}
\examples{
## A fourier basis with period 1 and 11 basis functions. 
bf <- make.fourier.basis(c(0,1), order = 5)

}
\seealso{
\link{Functional basis function}
}
