% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_ranef.R
\name{add_recode}
\alias{add_recode}
\title{Recode a categorical column}
\usage{
add_recode(.data, .col, .newcol = paste0(col, ".c"), ...)
}
\arguments{
\item{.data}{the data frame}

\item{.col}{the column to recode}

\item{.newcol}{the name of the recoded column (defaults to col.c)}

\item{...}{coding for categorical column}
}
\value{
data frame with new fixed effects columns
}
\description{
Recode a categorical column
}
\examples{
add_random(subj = 4, item = 4) \%>\%
  add_between("subj", cond = c("cntl", "test")) \%>\%
  add_recode("cond", "cond.t", cntl = 0, test = 1)
}
