% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/fast_pseudo_mean.R
\name{fast_pseudo_mean}
\alias{fast_pseudo_mean}
\title{Calculate pseudo-observations.}
\usage{
fast_pseudo_mean(time, event, tmax)
}
\arguments{
\item{time}{- Vector of follow-up times.}

\item{event}{- Vector of binary event statuses (0 = alive, 1 = dead).}

\item{tmax}{- Cut-off point for restricted mean survival time. Defaults to maximum follow-up time.}
}
\description{
Computes pseudo-observations for survival analysis on right-censored data based on restricted mean survival time.
}
\details{
Using a jacknife procedure and restricted mean survival time, this function calculates pseudo-observations for right-censored survival data. These pseudo-observations can be used as the response variable in a generalized estimating equations model. Missing values are not allowed in the time or event vector.
The function is equivalent to the pseudomean() function in the 'pseudo' package, but can handle data sets that are orders of magnitude larger.
}
\examples{
# Dummy data

id <- c(1, 2, 3, 4)
female <- c(0, 1, 1, 0)
time <- c(23, 45, 38, 66)
event <- c(1, 0, 0, 0)

# Compute pseudo-observations

pseudo = fast_pseudo_mean(time, event, 50)

# Create a data frame

test <- data.frame(id, female, pseudo)

# Fit a regression model

library(geepack)

summary(fit <- geese(pseudo ~ female,
data = test, id=id, jack = TRUE, family=gaussian,
corstr="independence", scale.fix=FALSE))
}

