% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_fill.R
\name{f_fill}
\alias{f_fill}
\title{Fill \code{NA} values forwards and backwards}
\usage{
f_fill(
  .data,
  ...,
  .by = NULL,
  .cols = NULL,
  .direction = c("forwards", "backwards"),
  .fill_limit = Inf,
  .new_names = "{.col}"
)
}
\arguments{
\item{.data}{A data frame.}

\item{...}{Cols to fill \code{NA} values specified through \code{tidyselect} notation.
If left empty all cols are used by default.}

\item{.by}{Cols to group by for this operation.
Specified through \code{tidyselect}.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{.direction}{Which direction should \code{NA} values be filled?
By default, "forwards" (Last-Observation-Carried-Forward) is used.
"backwards" is (Next-Observation-Carried-Backward).}

\item{.fill_limit}{The maximum number of consecutive \code{NA} values to fill.
Default is \code{Inf}.}

\item{.new_names}{A name specification for the names of filled variables.
The default \code{"{.col}"} replaces the given variables with the imputed ones.
New variables can be created alongside the originals if we give a different
specification, e.g.
\code{.new_names = "{.col}_imputed"}.
This follows the specification of \code{dplyr::across} if \code{.fns} were an empty
string \code{""}.}
}
\value{
A data frame with \code{NA} values filled forward or backward.
}
\description{
Fill \code{NA} values forwards and backwards
}
