% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_distinct.R
\name{f_distinct}
\alias{f_distinct}
\title{Find distinct rows}
\usage{
f_distinct(
  data,
  ...,
  .keep_all = FALSE,
  .sort = FALSE,
  .order = .sort,
  .by = NULL,
  .cols = NULL
)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Variables used to find distinct rows.}

\item{.keep_all}{If \code{TRUE} then all columns of data frame are kept,
default is \code{FALSE}.}

\item{.sort}{Should result be sorted? Default is \code{FALSE}.
When \code{order = FALSE} this option has no effect on the result.}

\item{.order}{Should the groups be calculated as ordered groups?
Setting to \code{TRUE} may sometimes offer a speed benefit, but usually this
is not the case. The default is \code{FALSE}.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}
}
\value{
A \code{data.frame} of distinct groups.
}
\description{
Like \code{dplyr::distinct()} but faster when lots of
groups are involved.
}
