% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.cluster.mean.R
\name{metric.cluster.mean}
\alias{metric.cluster.mean}
\title{Mean Local Clustering Coefficient}
\usage{
metric.cluster.mean(g)
}
\arguments{
\item{g}{The input network.}
}
\value{
A real constant.
}
\description{
Calculate the average local clustering coefficient of a graph.
}
\details{
The local clustering coefficient of a node is the ratio of the triangles connected to the node and the triples centered on the \code{node.metric.cluster.mean()} calculates the (estimated) average clustering coefficient for all nodes in graph \emph{g} with a justified error.
}
\examples{
\dontrun{
x <-  net.erdos.renyi.gnp(n = 1000, ncores = 3, p =  0.06)
metric.cluster.mean(x) }
}
\references{
Wasserman, Stanley, and Katherine Faust. Social network analysis: Methods and applications. Vol. 8. Cambridge university press, 1994.
}
\author{
Xu Dong, Nazrul Shaikh.
}
