% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric.distance.meanecc.R
\name{metric.distance.meanecc}
\alias{metric.distance.meanecc}
\title{Mean Eccentricity}
\usage{
metric.distance.meanecc(g, p)
}
\arguments{
\item{g}{The input network.}

\item{p}{The sampling probability.}
}
\value{
A real constant.
}
\description{
Calculate the mean eccentricity of a graph.
}
\details{
The mean eccentricities of all nodes in graph \emph{g}. Calculates the (estimated) mean eccentricity of graph \emph{g} with a justified error.
}
\examples{
\dontrun{
x <-  net.erdos.renyi.gnp(1000, 0.01)
metric.distance.meanecc(x, 0.01)}
}
\references{
West, Douglas Brent. Introduction to graph theory. Vol. 2. Upper Saddle River: Prentice Hall, 2001.
}
\author{
Xu Dong, Nazrul Shaikh.
}
