% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd_var}
\alias{fastcpd_var}
\alias{fastcpd.var}
\title{Find change points efficiently in VAR(p) models}
\usage{
fastcpd_var(data, order = 0, ...)

fastcpd.var(data, order = 0, ...)
}
\arguments{
\item{data}{A matrix, a data frame or a time series object.}

\item{order}{A positive integer specifying the order of the VAR model.}

\item{...}{Other arguments passed to \code{\link{fastcpd}}, for example,
\code{segment_count}.}
}
\value{
A class \code{fastcpd} object.
}
\description{
\code{fastcpd_var} and \code{fastcpd.var} are
wrapper functions of \code{\link{fastcpd.ts}} to find change points in
VAR(p) models. The function is similar to \code{\link{fastcpd.ts}}
except that the data is by default a matrix with row as an observation
and thus a formula is not required here.
}
\examples{
set.seed(1)
n <- 300
p <- 2
theta_1 <- matrix(c(-0.3, 0.6, -0.5, 0.4, 0.2, 0.2, 0.2, -0.2), nrow = p)
theta_2 <- matrix(c(0.3, -0.4, 0.1, -0.5, -0.5, -0.2, -0.5, 0.2), nrow = p)
x <- matrix(0, n + 2, p)
for (i in 1:200) {
  x[i + 2, ] <- theta_1 \%*\% c(x[i + 1, ], x[i, ]) + rnorm(p, 0, 1)
}
for (i in 201:n) {
  x[i + 2, ] <- theta_2 \%*\% c(x[i + 1, ], x[i, ]) + rnorm(p, 0, 1)
}
result <- fastcpd.var(x, 2, pruning = FALSE)
summary(result)
}
