% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastinference.R
\name{ShapInterpretation}
\alias{ShapInterpretation}
\title{ShapInterpretation}
\usage{
ShapInterpretation(
  learn,
  test_data = NULL,
  link = "identity",
  l1_reg = "auto",
  n_samples = 128
)
}
\arguments{
\item{learn}{learner/model}

\item{test_data}{should be either a Pandas dataframe or a TabularDataLoader. If not, 100 random rows of
the training data will be used instead.}

\item{link}{link can either be "identity" or "logit". A generalized linear model link to connect
the feature importance values to the model output. Since the feature importance values, phi, sum up
to the model output, it often makes sense to connect them to the ouput with a link function where
link(outout) = sum(phi). If the model output is a probability then the LogitLink link function makes
the feature importance values have log-odds units.}

\item{l1_reg}{can be an integer value representing the number of features, "auto", "aic", "bic", or
a float value. The l1 regularization to use for feature selection (the estimation procedure is based
on a debiased lasso). The auto option currently uses "aic" when less that 20% of the possible sample
space is enumerated, otherwise it uses no regularization.}

\item{n_samples}{can either be "auto" or an integer value. This is the number of times to re-evaluate
the model when explaining each predictions. More samples leads to lower variance estimations of the SHAP values}
}
\value{
None
}
\description{
Base interpereter to use the `SHAP` interpretation library
}
