% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastMatMR-package.R
\name{sparse_Matrix_to_fmm}
\alias{sparse_Matrix_to_fmm}
\title{Convert a Sparse Numeric Matrix to Matrix Market Format}
\arguments{
\item{input}{A sparse numeric matrix to be converted.}

\item{filename}{The name of the output file where the Matrix Market formatted
data will be saved.}
}
\value{
A boolean indicating success or failure. Writes a MTX file to disk.
}
\description{
This function takes a sparse numeric matrix and converts it into
a Matrix Market file.
}
\examples{
sparse_mat <- Matrix::Matrix(c(1, 0, 0, 2), nrow = 2, sparse = TRUE)
sparse_Matrix_to_fmm(sparse_mat, tempfile(fileext = ".mtx"))
}
