% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastDummies.R
\name{dummy_rows}
\alias{dummy_rows}
\title{Fast creation of dummy rows}
\usage{
dummy_rows(dataset, select_columns = NULL, add_columns = NULL,
  ignore_columns = NULL, dummy_value = 0, year = FALSE,
  return_type = "data.table", dummy_indicator = FALSE)
}
\arguments{
\item{dataset}{data.table or data.frame}

\item{select_columns}{If NULL, uses character, factor, and Date columns to produce categories
to make the dummy rows by. If not NULL, you manually enter a string or vector
of columns name(s).}

\item{add_columns}{String or vector of column name(s) to add to the selected coumns. This is only
if you want to use all character, factor, and Date columns (selected by
default) and are adding additional columns of different data types.}

\item{ignore_columns}{String or vector of column name(s) to exclude from the selected columns.
These excluded columns will get the same dummy value of all non-selected
columns}

\item{dummy_value}{Value of the row for columns that are not selected. Default is a value of 0.}

\item{year}{TRUE to include a column called year (capitalization is ignored)
as one of the selected columns.}

\item{return_type}{Type of data you want back_ Default is data.table (better for use
with large data)_ Other option is data.frame.}

\item{dummy_indicator}{Adds binary column to say if row is dummy or not (i.e. included in
original data or not)}
}
\value{
data.table or data.frame depending on input for return_type.
data.table is default.
}
\description{
Fast creation of dummy rows
}
\examples{
data(dummy_rows_example)

# Makes dummy rows using default column selection and year
# to make categories
example <- dummy_rows(dummy_rows_example, year = TRUE)

# Same as above but adds binary column indicating if the row
# is dummy or not
example <- dummy_rows(dummy_rows_example, year = TRUE, dummy_indicator = TRUE)
}
