% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_annual_extremes_year.R
\name{plot_annual_extremes_year}
\alias{plot_annual_extremes_year}
\title{Plot annual high and low flows for a specific year}
\usage{
plot_annual_extremes_year(
  data,
  dates = Date,
  values = Value,
  groups = STATION_NUMBER,
  station_number,
  year_to_plot = NA,
  roll_days = 1,
  roll_days_min = NA,
  roll_days_max = NA,
  roll_align = "right",
  water_year_start = 1,
  start_year,
  end_year,
  exclude_years,
  months = 1:12,
  months_min = NA,
  months_max = NA,
  log_discharge = TRUE,
  log_ticks = FALSE,
  include_title = FALSE,
  plot_normal_percentiles = TRUE,
  normal_percentiles = c(25, 75),
  plot_min = TRUE,
  plot_max = TRUE,
  complete_years = FALSE,
  ignore_missing = FALSE,
  allowed_missing = ifelse(ignore_missing, 100, 0)
)
}
\arguments{
\item{data}{Data frame of daily data that contains columns of dates, flow values, and (optional) groups (e.g. station numbers).
Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{dates}{Name of column in \code{data} that contains dates formatted YYYY-MM-DD. Only required if dates column name is not 
'Date' (default). Leave blank or set to \code{NULL} if using \code{station_number} argument.}

\item{values}{Name of column in \code{data} that contains numeric flow values, in units of cubic metres per second.
Only required if values column name is not 'Value' (default). Leave blank if using \code{station_number} argument.}

\item{groups}{Name of column in \code{data} that contains unique identifiers for different data sets, if applicable. Only required 
if groups column name is not 'STATION_NUMBER'. Function will automatically group by a column named 'STATION_NUMBER' if 
present. Remove the 'STATION_NUMBER' column beforehand to remove this grouping. Leave blank if using \code{station_number} 
argument.}

\item{station_number}{Character string vector of seven digit Water Survey of Canada station numbers (e.g. \code{"08NM116"}) of
which to extract daily streamflow data from a HYDAT database. Requires \code{tidyhydat} package and a HYDAT database.
Leave blank if using \code{data} argument.}

\item{year_to_plot}{Numeric value indicating the year/water year to plot flow data with normal category colours. Default \code{NA}.}

\item{roll_days}{Numeric value of the number of days to apply a rolling mean. Default \code{1}.}

\item{roll_days_min}{Numeric value of the number of days to apply a rolling mean for low flows.  Will override 'roll_days' argument 
for low flows. Default \code{NA}.}

\item{roll_days_max}{Numeric value of the number of days to apply a rolling mean for high flows.  Will override 'roll_days' argument 
for high flows. Default \code{NA}.}

\item{roll_align}{Character string identifying the direction of the rolling mean from the specified date, either by the first 
(\code{'left'}), last (\code{'right'}), or middle (\code{'center'}) day of the rolling n-day group of observations. 
Default \code{'right'}.}

\item{water_year_start}{Numeric value indicating the month (\code{1} through \code{12}) of the start of water year for
analysis. Default \code{1}.}

\item{start_year}{Numeric value of the first year to consider for analysis. Leave blank or set well before start date (i.e.
\code{1800}) to use from the first year of the source data.}

\item{end_year}{Numeric value of the last year to consider for analysis. Leave blank or set well after end date (i.e.
\code{2100}) to use up to the last year of the source data.}

\item{exclude_years}{Numeric vector of years to exclude from analysis. Leave blank or set to \code{NULL} to include all years.}

\item{months}{Numeric vector of specific months to plot. For example, \code{3} for March, \code{6:8} for Jun-Aug.
Will be overridden for low or high flow statistics if \code{months_min} or \code{months_max} set, but will still 
define the date limits on the x-axis. Default plots all months (\code{1:12}).}

\item{months_min}{Numeric vector of specified months for window of low flows (3 for March, 6:8 for Jun-Aug). Will override 'months' 
argument for low flows. Default \code{NA}.}

\item{months_max}{Numeric vector of specified months for window of high flows (3 for March, 6:8 for Jun-Aug). Will override 'months' 
argument for high flows. Default \code{NA}.}

\item{log_discharge}{Logical value to indicate plotting the discharge axis (Y-axis) on a logarithmic scale. Default \code{FALSE}.}

\item{log_ticks}{Logical value to indicate plotting logarithmic scale ticks when \code{log_discharge = TRUE}. Ticks will not
appear when \code{log_discharge = FALSE}. Default to \code{TRUE} when \code{log_discharge = TRUE}.}

\item{include_title}{Logical value to indicate adding the group/station number to the plot, if provided. Default \code{FALSE}.}

\item{plot_normal_percentiles}{Logical value indicating whether to plot the normal percentiles ribbon. Default \code{TRUE}.}

\item{normal_percentiles}{Numeric vector of two values, lower and upper percentiles, respectively indicating the limits of the 
normal range. Default \code{c(25,75)}.}

\item{plot_min}{Logical value indicating whether to plot annual low flows. Default \code{TRUE}.}

\item{plot_max}{Logical value indicating whether to plot annual high flows. Default \code{TRUE}.}

\item{complete_years}{Logical values indicating whether to include only years with complete data in analysis. Default \code{FALSE}.}

\item{ignore_missing}{Logical value indicating whether dates with missing values should be included in the calculation. If
\code{TRUE} then a statistic will be calculated regardless of missing dates. If \code{FALSE} then only those statistics from
time periods with no missing dates will be returned. Default \code{FALSE}.}

\item{allowed_missing}{Numeric value between 0 and 100 indicating the \strong{percentage} of missing dates allowed to be
included to calculate a statistic (0 to 100 percent). If \code{'ignore_missing = FALSE'} then it defaults to \code{0} (zero missing dates allowed),
if \code{'ignore_missing = TRUE'} then it defaults to \code{100} (any missing dates allowed); consistent with 
\code{ignore_missing} usage. Supersedes \code{ignore_missing} when used.}
}
\value{
A list of ggplot2 objects with the following for each station provided:
  \item{Annual_Extremes_Year}{a plot that contains the an annual hydrograph and identified low and high flow periods}
}
\description{
Plots an annual hydrograph for a specific year with the values and timing of annual n-day low and high flows.
   The 'normal' range of percentiles also plotted for reference and are calculated from only years of complete data. 
   Shows the values and dates of max/mins for a specific year from the \code{calc_annual_extremes()} and
   \code{plot_annual_extremes()} functions. Can remove either low or high flows using \code{plot_min = FALSE()} or 
   \code{plot_max = FALSE()}, respectively. Returns a list of plots.
}
\examples{
# Run if HYDAT database has been downloaded (using tidyhydat::download_hydat())
if (file.exists(tidyhydat::hy_downloaded_db())) {

# Plot the year 2000 with the annual maximum and minimums       
plot_annual_extremes_year(station_number = "08NM116",
                          roll_days_max = 3,
                          roll_days_min = 7,
                          year_to_plot = 2001)
                 
}
}
\seealso{
\code{\link{calc_annual_extremes}}

\code{\link{plot_annual_extremes}}
}
