test_that("test that serial and parallel versions return same statistics", {
    ## To avoid ASAN/UBSAN errors on CRAN, following advice given at
    ## https://github.com/RcppCore/RcppParallel/issues/169
    Sys.setenv(RCPP_PARALLEL_BACKEND = "tinythread")

    set.seed(0)

    S1 <- data.frame(rnorm(n = 100, mean = 1, sd = 1),
                     rnorm(n = 100, mean = 1, sd = 1))
    S2 <- data.frame(rnorm(n = 103, mean = 1, sd = 1),
                     rnorm(n = 103, mean = 1, sd = 1))

    test1 <- fasano.franceschini.test(S1, S2, nPermute = 34, threads = 1, method = 'r')
    test4 <- fasano.franceschini.test(S1, S2, nPermute = 20, threads = 4, method = 'b')
    expect_equal(test1$statistic, test4$statistic, tolerance = 1e-14)
    expect_equal(test1$estimate, test4$estimate, tolerance = 1e-14)

    test1 <- fasano.franceschini.test(S1, S2, nPermute = 34, threads = 1, method = 'b')
    test4 <- fasano.franceschini.test(S1, S2, nPermute = 20, threads = 4, method = 'r')
    expect_equal(test1$statistic, test4$statistic, tolerance = 1e-14)
    expect_equal(test1$estimate, test4$estimate, tolerance = 1e-14)

    S1 <- data.frame(rnorm(n = 100, mean = 1, sd = 2),
                     rnorm(n = 100, mean = 1, sd = 1))
    S2 <- data.frame(rnorm(n = 103, mean = 1, sd = 1),
                     rnorm(n = 103, mean = 1, sd = 2))

    test1 <- fasano.franceschini.test(S1, S2, nPermute = 31, threads = 1)
    test4 <- fasano.franceschini.test(S1, S2, nPermute = 37, threads = 4)
    expect_equal(test1$statistic, test4$statistic, tolerance = 1e-14)
    expect_equal(test1$estimate, test4$estimate, tolerance = 1e-14)

    test1 <- fasano.franceschini.test(S1, S2, nPermute = 20, threads = 1)
    test4 <- fasano.franceschini.test(S1, S2, nPermute = 20, threads = 4)
    expect_equal(test1$statistic, test4$statistic, tolerance = 1e-14)
    expect_equal(test1$estimate, test4$estimate, tolerance = 1e-14)

    test1 <- fasano.franceschini.test(S1, S2, nPermute = 10, threads = 1)
    test2 <- fasano.franceschini.test(S1, S2, nPermute = 20, threads = 2)
    test3 <- fasano.franceschini.test(S1, S2, nPermute = 30, threads = 3)
    test4 <- fasano.franceschini.test(S1, S2, nPermute = 40, threads = 4)
    expect_equal(test1$statistic, test2$statistic, tolerance = 1e-14)
    expect_equal(test1$estimate, test2$estimate, tolerance = 1e-14)
    expect_equal(test1$statistic, test3$statistic, tolerance = 1e-14)
    expect_equal(test1$estimate, test3$estimate, tolerance = 1e-14)
    expect_equal(test1$statistic, test4$statistic, tolerance = 1e-14)
    expect_equal(test1$estimate, test4$estimate, tolerance = 1e-14)
    expect_equal(test2$statistic, test3$statistic, tolerance = 1e-14)
    expect_equal(test2$estimate, test3$estimate, tolerance = 1e-14)
    expect_equal(test2$statistic, test4$statistic, tolerance = 1e-14)
    expect_equal(test2$estimate, test4$estimate, tolerance = 1e-14)
    expect_equal(test3$statistic, test4$statistic, tolerance = 1e-14)
    expect_equal(test3$estimate, test4$estimate, tolerance = 1e-14)
})
