/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.IntegratorException;
import org.apache.commons.math.ode.StepInterpolator;
import org.apache.commons.math.ode.SwitchState;
import org.apache.commons.math.ode.SwitchingFunction;

public class SwitchingFunctionsHandler {
    private ArrayList functions = new ArrayList();
    private SwitchState first = null;
    private boolean initialized = false;

    public void add(SwitchingFunction function, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.functions.add(new SwitchState(function, maxCheckInterval, convergence, maxIterationCount));
    }

    public boolean isEmpty() {
        return this.functions.isEmpty();
    }

    public boolean evaluateStep(StepInterpolator interpolator) throws DerivativeException, IntegratorException {
        try {
            this.first = null;
            if (this.functions.isEmpty()) {
                return false;
            }
            if (!this.initialized) {
                double t0 = interpolator.getPreviousTime();
                interpolator.setInterpolatedTime(t0);
                double[] y = interpolator.getInterpolatedState();
                Iterator iter = this.functions.iterator();
                while (iter.hasNext()) {
                    ((SwitchState)iter.next()).reinitializeBegin(t0, y);
                }
                this.initialized = true;
            }
            Iterator iter = this.functions.iterator();
            while (iter.hasNext()) {
                SwitchState state = (SwitchState)iter.next();
                if (!state.evaluateStep(interpolator)) continue;
                if (this.first == null) {
                    this.first = state;
                    continue;
                }
                if (interpolator.isForward()) {
                    if (!(state.getEventTime() < this.first.getEventTime())) continue;
                    this.first = state;
                    continue;
                }
                if (!(state.getEventTime() > this.first.getEventTime())) continue;
                this.first = state;
            }
            return this.first != null;
        }
        catch (FunctionEvaluationException fee) {
            throw new IntegratorException(fee);
        }
        catch (ConvergenceException ce) {
            throw new IntegratorException(ce);
        }
    }

    public double getEventTime() {
        return this.first == null ? Double.NaN : this.first.getEventTime();
    }

    public void stepAccepted(double t, double[] y) throws IntegratorException {
        try {
            Iterator iter = this.functions.iterator();
            while (iter.hasNext()) {
                ((SwitchState)iter.next()).stepAccepted(t, y);
            }
        }
        catch (FunctionEvaluationException fee) {
            throw new IntegratorException(fee);
        }
    }

    public boolean stop() {
        Iterator iter = this.functions.iterator();
        while (iter.hasNext()) {
            if (!((SwitchState)iter.next()).stop()) continue;
            return true;
        }
        return false;
    }

    public boolean reset(double t, double[] y) {
        boolean resetDerivatives = false;
        Iterator iter = this.functions.iterator();
        while (iter.hasNext()) {
            if (!((SwitchState)iter.next()).reset(t, y)) continue;
            resetDerivatives = true;
        }
        return resetDerivatives;
    }
}

