/*
 * Decompiled with CFR 0.152.
 */
package jfm.lp;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import jfm.lp.LPX;
import jfm.lp.MatrixElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MatrixRow {
    public final double upperBound;
    public final double lowerBound;
    public final LPX type;
    public final int row;
    public final String setByComponent;
    private final Set<MatrixElement> elements = new LinkedHashSet<MatrixElement>();
    public final String tag;

    public Set<MatrixElement> elements() {
        return Collections.unmodifiableSet(this.elements);
    }

    public MatrixRow(double low, double up, LPX type_, int row_, String setBy, String tag_) {
        this.upperBound = up;
        this.lowerBound = low;
        this.type = type_;
        this.row = row_;
        this.setByComponent = setBy;
        this.tag = tag_;
    }

    private void replaceElement(MatrixElement newElement) {
        if (!this.elements.remove(newElement)) {
            throw new Error("replaceElement should only be called on elements that already exist in the matrix");
        }
        if (!this.elements.add(newElement)) {
            throw new Error("This should not happen");
        }
    }

    public boolean addElement(MatrixElement newElement) {
        if (newElement.value == 0.0) {
            this.elements.remove(newElement);
            return true;
        }
        if (!this.elements.add(newElement)) {
            this.replaceElement(newElement);
            return true;
        }
        return true;
    }
}

