% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_metric_scores.R
\name{plot.metric_scores}
\alias{plot.metric_scores}
\title{Plot metric scores}
\usage{
\method{plot}{metric_scores}(x, ...)
}
\arguments{
\item{x}{\code{metric_scores} object}

\item{...}{other plot parameters}
}
\value{
\code{ggplot2} object
}
\description{
Plot metric scores
}
\examples{
data("german")

y_numeric <- as.numeric(german$Risk) -1

lm_model <- glm(Risk~.,
                data = german,
                family=binomial(link="logit"))

rf_model <- ranger::ranger(Risk ~.,
                           data = german,
                           probability = TRUE,
                           num.trees = 200)

explainer_lm <- DALEX::explain(lm_model, data = german[,-1], y = y_numeric)
explainer_rf <- DALEX::explain(rf_model, data = german[,-1], y = y_numeric)

fobject <- fairness_check(explainer_lm, explainer_rf,
                          protected = german$Sex,
                          privileged = "male")

ms <- metric_scores(fobject, fairness_metrics = c("TPR","STP","ACC"))
plot(ms)

}
