# Engines API
#
# Allow clients to fetch Engines Analytics through APIs.
#
# The version of the OpenAPI document: 2
# Contact: analytics.api.support@factset.com
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title VaultComponent
#' @description VaultComponent Class
#' @format An \code{R6Class} generator object
#' @field id  character [optional]
#'
#' @field account  \link{VaultIdentifier} [optional]
#'
#' @field benchmark  \link{VaultIdentifier} [optional]
#'
#' @field currencyisocode  character [optional]
#'
#' @field dates  \link{VaultDateParameters} [optional]
#'
#' @field snapshot  character [optional]
#'
#' @field name  character [optional]
#'
#' @field category  character [optional]
#'
#'
#' @importFrom R6 R6Class
#' @importFrom jsonlite fromJSON toJSON
#' @export
VaultComponent <- R6::R6Class(
  'VaultComponent',
  public = list(
    `id` = NULL,
    `account` = NULL,
    `benchmark` = NULL,
    `currencyisocode` = NULL,
    `dates` = NULL,
    `snapshot` = NULL,
    `name` = NULL,
    `category` = NULL,
    initialize = function(`id`=NULL, `account`=NULL, `benchmark`=NULL, `currencyisocode`=NULL, `dates`=NULL, `snapshot`=NULL, `name`=NULL, `category`=NULL, ...){
      local.optional.var <- list(...)
      if (!is.null(`id`)) {
        stopifnot(is.character(`id`), length(`id`) == 1)
        self$`id` <- `id`
      }
      if (!is.null(`account`)) {
        stopifnot(R6::is.R6(`account`))
        self$`account` <- `account`
      }
      if (!is.null(`benchmark`)) {
        stopifnot(R6::is.R6(`benchmark`))
        self$`benchmark` <- `benchmark`
      }
      if (!is.null(`currencyisocode`)) {
        stopifnot(is.character(`currencyisocode`), length(`currencyisocode`) == 1)
        self$`currencyisocode` <- `currencyisocode`
      }
      if (!is.null(`dates`)) {
        stopifnot(R6::is.R6(`dates`))
        self$`dates` <- `dates`
      }
      if (!is.null(`snapshot`)) {
        self$`snapshot` <- `snapshot`
      }
      if (!is.null(`name`)) {
        stopifnot(is.character(`name`), length(`name`) == 1)
        self$`name` <- `name`
      }
      if (!is.null(`category`)) {
        stopifnot(is.character(`category`), length(`category`) == 1)
        self$`category` <- `category`
      }
    },
    toJSON = function() {
      VaultComponentObject <- list()
      if (!is.null(self$`id`)) {
        VaultComponentObject[['id']] <-
          self$`id`
      }
      if (!is.null(self$`account`)) {
        VaultComponentObject[['account']] <-
          self$`account`$toJSON()
      }
      if (!is.null(self$`benchmark`)) {
        VaultComponentObject[['benchmark']] <-
          self$`benchmark`$toJSON()
      }
      if (!is.null(self$`currencyisocode`)) {
        VaultComponentObject[['currencyisocode']] <-
          self$`currencyisocode`
      }
      if (!is.null(self$`dates`)) {
        VaultComponentObject[['dates']] <-
          self$`dates`$toJSON()
      }
      if (!is.null(self$`snapshot`)) {
        VaultComponentObject[['snapshot']] <-
          self$`snapshot`
      }
      if (!is.null(self$`name`)) {
        VaultComponentObject[['name']] <-
          self$`name`
      }
      if (!is.null(self$`category`)) {
        VaultComponentObject[['category']] <-
          self$`category`
      }

      VaultComponentObject
    },
    fromJSON = function(VaultComponentJson) {
      VaultComponentObject <- jsonlite::fromJSON(VaultComponentJson)
      if (!is.null(VaultComponentObject$`id`)) {
        self$`id` <- VaultComponentObject$`id`
      }
      if (!is.null(VaultComponentObject$`account`)) {
        accountObject <- VaultIdentifier$new()
        accountObject$fromJSON(jsonlite::toJSON(VaultComponentObject$account, auto_unbox = TRUE, digits = NA))
        self$`account` <- accountObject
      }
      if (!is.null(VaultComponentObject$`benchmark`)) {
        benchmarkObject <- VaultIdentifier$new()
        benchmarkObject$fromJSON(jsonlite::toJSON(VaultComponentObject$benchmark, auto_unbox = TRUE, digits = NA))
        self$`benchmark` <- benchmarkObject
      }
      if (!is.null(VaultComponentObject$`currencyisocode`)) {
        self$`currencyisocode` <- VaultComponentObject$`currencyisocode`
      }
      if (!is.null(VaultComponentObject$`dates`)) {
        datesObject <- VaultDateParameters$new()
        datesObject$fromJSON(jsonlite::toJSON(VaultComponentObject$dates, auto_unbox = TRUE, digits = NA))
        self$`dates` <- datesObject
      }
      if (!is.null(VaultComponentObject$`snapshot`)) {
        self$`snapshot` <- VaultComponentObject$`snapshot`
      }
      if (!is.null(VaultComponentObject$`name`)) {
        self$`name` <- VaultComponentObject$`name`
      }
      if (!is.null(VaultComponentObject$`category`)) {
        self$`category` <- VaultComponentObject$`category`
      }
    },
    toJSONString = function() {
      jsoncontent <- c(
        if (!is.null(self$`id`)) {
        sprintf(
        '"id":
          "%s"
                ',
        self$`id`
        )},
        if (!is.null(self$`account`)) {
        sprintf(
        '"account":
        %s
        ',
        jsonlite::toJSON(self$`account`$toJSON(), auto_unbox=TRUE, digits = NA)
        )},
        if (!is.null(self$`benchmark`)) {
        sprintf(
        '"benchmark":
        %s
        ',
        jsonlite::toJSON(self$`benchmark`$toJSON(), auto_unbox=TRUE, digits = NA)
        )},
        if (!is.null(self$`currencyisocode`)) {
        sprintf(
        '"currencyisocode":
          "%s"
                ',
        self$`currencyisocode`
        )},
        if (!is.null(self$`dates`)) {
        sprintf(
        '"dates":
        %s
        ',
        jsonlite::toJSON(self$`dates`$toJSON(), auto_unbox=TRUE, digits = NA)
        )},
        if (!is.null(self$`snapshot`)) {
        sprintf(
        '"snapshot":
          "%s"
                ',
        self$`snapshot`
        )},
        if (!is.null(self$`name`)) {
        sprintf(
        '"name":
          "%s"
                ',
        self$`name`
        )},
        if (!is.null(self$`category`)) {
        sprintf(
        '"category":
          "%s"
                ',
        self$`category`
        )}
      )
      jsoncontent <- paste(jsoncontent, collapse = ",")
      paste('{', jsoncontent, '}', sep = "")
    },
    fromJSONString = function(VaultComponentJson) {
      VaultComponentObject <- jsonlite::fromJSON(VaultComponentJson)
      self$`id` <- VaultComponentObject$`id`
      self$`account` <- VaultIdentifier$new()$fromJSON(jsonlite::toJSON(VaultComponentObject$account, auto_unbox = TRUE, digits = NA))
      self$`benchmark` <- VaultIdentifier$new()$fromJSON(jsonlite::toJSON(VaultComponentObject$benchmark, auto_unbox = TRUE, digits = NA))
      self$`currencyisocode` <- VaultComponentObject$`currencyisocode`
      self$`dates` <- VaultDateParameters$new()$fromJSON(jsonlite::toJSON(VaultComponentObject$dates, auto_unbox = TRUE, digits = NA))
      self$`snapshot` <- VaultComponentObject$`snapshot`
      self$`name` <- VaultComponentObject$`name`
      self$`category` <- VaultComponentObject$`category`
      self
    }
  )
)
