% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multifabCIhom.R
\name{hhommodel}
\alias{hhommodel}
\title{Hierarchical homoscedastic model estimates}
\usage{
hhommodel(y, g, group, p1)
}
\arguments{
\item{y}{a numeric vector of data}

\item{g}{a group membership vector, of the same length as y}

\item{group}{the index of the group}

\item{p1}{number of groups used to pool sample variance}
}
\value{
A vector (s2,df,muw,t2w,s2w), where 
\enumerate{
\item s2 is the pooled variance 
\item df is the degree of freedom of the t-quantiles
\item muw is the estimate mean of the group means 
\item t2w is the estimate variance of the group means
\item s2w is the estimate within-group variance
}
}
\description{
Estimate across-group heterogeneity of means
}
\details{
This function estimates 
parameters in a hierarchical model for normally distributed
groups, where the across-group model for means is normal 
and the variance is the same across groups.
}
\author{
Chaoyu Yu
}
\keyword{htest}

