% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DCT_FFT_detrending.R
\name{detrend}
\alias{detrend}
\title{Detrending with DCT or FFT}
\usage{
detrend(X, TR, f = 0.008, method = c("DCT", "FFT"))
}
\arguments{
\item{X}{\eqn{T \times V} numeric matrix. Each column is a voxel or vertex
time series.}

\item{TR}{TR of the fMRI scan, in seconds (the time between timepoints)}

\item{f}{Hz of highpass filter. Default: \code{.008}}

\item{method}{\code{"DCT"} (default) or \code{"FFT"}.}
}
\value{
Detrended \code{X}
}
\description{
Detrending with DCT or FFT
}
\examples{
detrend(matrix(rnorm(700), nrow=100), TR=.72)
}
