% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FD.R
\name{FD}
\alias{FD}
\title{Framewise Displacement}
\usage{
FD(
  X,
  trans_units = c("mm", "cm", "in"),
  rot_units = c("deg", "rad", "mm", "cm", "in"),
  brain_radius = NULL,
  detrend = FALSE,
  lag = 1,
  cutoff = 0.3
)
}
\arguments{
\item{X}{An \eqn{N} by \eqn{6} matrix in which the first three columns represent the
translational RPs (\code{trans_units}), and the second three columns represent
the rotational RPs (\code{rot_units}). If \code{rot_units} measures an angle,
it will be converted to \code{trans_units} by measuring displacement on a
sphere of radius \code{brain_radius} \code{trans_units}.

Alternatively, this can be the file path to an \eqn{N} by \eqn{6} matrix which can be
read with \code{\link[utils]{read.table}} (fields separated by white-space; no
header).}

\item{trans_units}{\code{"mm"} for millimeters (default), \code{"cm"}
for centimeters, or \code{"in"} for inches.}

\item{rot_units}{\code{"deg"} for degrees (default), \code{"rad"} for radians,
or one of the \code{trans_units} options.}

\item{brain_radius}{If \code{rot_units} measures an angle, the rotational RPs
are transformed to a spatial measurement representing the displacement on a
sphere of radius \code{brain_radius} \code{trans_units}.

If \code{brain_radius} is \code{NULL} (default), it will be set to
50 mm.}

\item{detrend}{Detrend each RP with the DCT before computing FD?
Default: \code{FALSE}. Can be a number of DCT bases to use, or \code{TRUE}
to use 4.}

\item{lag}{The difference of indices between which to calculate change in
position. Default: \code{1} (the previous timepoint). Changing this
argument sets \eqn{\Delta x_i = x_{i-lag} - x_i} (and similarly for the
other RPs).}

\item{cutoff}{FD values higher than this will be flagged. Default: \code{.3}.}
}
\value{
A list with components
\describe{
\item{measure}{A length \eqn{N} vector of FD values in \code{trans_units}.}
\item{measure_info}{"FD"}
\item{outlier_cutoff}{\code{cutoff}}
\item{outlier_flag}{A length-N logical vector, where \code{TRUE} indicates suspected outlier presence.}
}
}
\description{
Calculate Framewise Displacement (FD)
}
\details{
The FD formula is taken from Power et. al. (2012):

\deqn{FD_i = | \Delta x_i | + | \Delta y_i | + | \Delta z_i | + | \Delta \alpha_i | + | \Delta \beta_i | + | \Delta \gamma_i |}

where \eqn{i} is the timepoint; \eqn{x}, \eqn{y} and \eqn{z} are the
translational realignment parameters (RPs);
\eqn{\alpha}, \eqn{\beta} and \eqn{\gamma} are the rotational RPs;
and \eqn{\Delta x_i = x_{i-1} - x_i} (and similarly for the other RPs).
}
\section{References}{

\itemize{
\item{Power, J. D., Barnes, K. A., Snyder, A. Z., Schlaggar, B. L. & Petersen, S. E. Spurious but systematic correlations in functional connectivity MRI networks arise from subject motion. Neuroimage 59, 2142-2154 (2012).}
}
}

