% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DVARS.R
\name{DVARS}
\alias{DVARS}
\title{DVARS}
\usage{
DVARS(
  X,
  normalize = TRUE,
  cutoff_DPD = 5,
  cutoff_ZD = qnorm(1 - 0.05/nrow(as.matrix2(X))),
  verbose = FALSE
)
}
\arguments{
\item{X}{a \eqn{T} by \eqn{N} numeric matrix representing an fMRI run. There should
not be any missing data (\code{NA} or \code{NaN}).}

\item{normalize}{Normalize the data? Default: \code{TRUE}. Normalization removes
constant-zero voxels, scales by 100 / the median of the mean image, and
then centers each voxel on its mean.

To replicate Afyouni and Nichols' procedure for the HCP MPP data, since the
HCP scans are already normalized to 10,000, just divide the data by 100 and
center the voxels on their means:

\code{Y <- Y/100; DVARS(t(Y - apply(Y, 1, mean)))} where \code{Y} is the
\eqn{V} by \eqn{T} data matrix.

Note that while voxel centering doesn't affect DVARS, it does affect
DPD and ZD.}

\item{cutoff_DPD, cutoff_ZD}{Numeric outlier cutoffs. Timepoints
exceeding these cutoffs will be flagged as outliers.}

\item{verbose}{Should occasional updates be printed? Default is \code{FALSE}.}
}
\value{
A list with components
\describe{
\item{measure}{A data.frame with \eqn{T} rows, each column being a different variant of DVARS.}
\item{measure_info}{"DVARS"}
\item{outlier_cutoff}{The outlier cutoff value(s).}
\item{outlier_flag}{A logical data.frame with \eqn{T} rows, where \code{TRUE} indicates suspected outlier presence.}
}
}
\description{
Computes the DSE decomposition and DVARS-related statistics. Based on code
from github.com/asoroosh/DVARS .
}
\section{References}{

\itemize{
\item{Afyouni, S. & Nichols, T. E. Insight and inference for DVARS. NeuroImage 172, 291-312 (2018).}
}
}

