% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_ci.R
\name{compute_ci}
\alias{compute_ci}
\title{Computing confidence intervals}
\usage{
compute_ci(x, alpha = 0.05)
}
\arguments{
\item{x}{An object of class \code{fHMM_model}.}

\item{alpha}{The alpha level for the confidence interval, a numeric between 0 and 1.
Per default, \code{alpha = 0.05}, which computes a 95\% confidence interval.}
}
\value{
A list containing the following elements:
\itemize{
\item \code{lb}: lower bound of confidence
\item \code{estimate}: point estimate
\item \code{ub}: upper bound of confidence
}
}
\description{
This function computes confidence intervals for the estimates of an
\code{fHMM_model} object using the inverse Fisher information.
}
\examples{
data("dax_model_3t")
fHMM:::compute_ci(x = dax_model_3t, alpha = 0.05)

}
\keyword{internal}
